/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IssueObjectIssuesIterable
implements IssuesIterable {
    private final Collection<Issue> issueObjects;

    public IssueObjectIssuesIterable(Collection<? extends Issue> issueObjects) {
        this.issueObjects = Collections.unmodifiableCollection(new ArrayList<Issue>(issueObjects));
    }

    protected Issue transform(Object o) {
        return (Issue)o;
    }

    public final void foreach(Consumer<Issue> sink) {
        CollectionUtil.foreach(this.issueObjects, sink);
    }

    public int size() {
        return this.issueObjects.size();
    }

    public boolean isEmpty() {
        return this.issueObjects.isEmpty();
    }

    public String toString() {
        List issueKeys = CollectionUtil.transform(this.issueObjects, (Function)new Function<Issue, String>(){

            public String get(Issue object) {
                return object.getKey();
            }
        });
        return this.getClass().getName() + " (" + this.size() + " items): " + issueKeys;
    }
}

