/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.KickassSearchContext;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import webwork.action.Action;

public class TextQuerySearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final KickassSearchContext kickassSearchContext;
    private final String name;
    private final String labelKey;
    private final SearchInputTransformer searchInputTransformer;

    public TextQuerySearchRenderer(String id, String name, String labelKey, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, KickassSearchContext kickassSearchContext, SearchInputTransformer searchInputTransformer) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, id, labelKey);
        this.name = name;
        this.labelKey = labelKey;
        this.searchInputTransformer = searchInputTransformer;
        this.kickassSearchContext = kickassSearchContext;
    }

    public String getEditHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        String value = "";
        if (fieldValuesHolder != null) {
            value = (String)fieldValuesHolder.get((Object)this.name);
        }
        if (this.kickassSearchContext.isEnabled()) {
            return TextUtils.htmlEncode((String)value);
        }
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("value", value);
        velocityParams.put("name", this.name);
        return this.renderEditTemplate("textquery-edit.vm", velocityParams);
    }

    public boolean isShown(User user, SearchContext searchContext) {
        return true;
    }

    public String getViewHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        String value = "";
        if (fieldValuesHolder != null) {
            value = (String)fieldValuesHolder.get((Object)this.name);
        }
        if (this.kickassSearchContext.isEnabled()) {
            return TextUtils.htmlEncode((String)value);
        }
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("value", value);
        velocityParams.put("name", this.name);
        return this.renderViewTemplate("textquery-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(User user, Query query) {
        return this.searchInputTransformer.doRelevantClausesFitFilterForm(user, query, null);
    }
}

