/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.KickassSearchContext;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import java.util.Map;
import webwork.action.Action;

public class GenericTextSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final KickassSearchContext kickassSearchContext;
    private final String id;
    private final String fieldId;
    private final SearchInputTransformer searchInputTransformer;
    private final FieldVisibilityManager fieldVisibilityManager;

    public GenericTextSearchRenderer(String id, String labelKey, String fieldId, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, KickassSearchContext kickassSearchContext, SearchInputTransformer searchInputTransformer, FieldVisibilityManager fieldVisibilityManager) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, id, labelKey);
        this.id = id;
        this.fieldId = fieldId;
        this.searchInputTransformer = searchInputTransformer;
        this.kickassSearchContext = kickassSearchContext;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public String getEditHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        String value = "";
        if (fieldValuesHolder != null) {
            value = (String)fieldValuesHolder.get((Object)this.id);
        }
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("value", value);
        velocityParams.put("name", this.id);
        return this.renderEditTemplate("textquery-edit.vm", velocityParams);
    }

    public boolean isShown(User user, SearchContext searchContext) {
        return this.kickassSearchContext.isEnabled() && !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.fieldId, searchContext, user);
    }

    public String getViewHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        String value = "";
        if (fieldValuesHolder != null) {
            value = (String)fieldValuesHolder.get((Object)this.id);
        }
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("value", value);
        velocityParams.put("name", this.id);
        velocityParams.put("fieldId", this.id);
        return this.renderViewTemplate("textquery-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(User user, Query query) {
        return this.searchInputTransformer.doRelevantClausesFitFilterForm(user, query, null);
    }
}

