/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.IssueUtils;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comparator.IssueKeyComparator;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.managers.IssueDeleteHelper;
import com.atlassian.jira.issue.search.parameters.filter.NoBrowsePermissionPredicate;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.InvalidInputException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityListIterator;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueManager
implements IssueManager {
    private static final Logger log = Logger.getLogger(DefaultIssueManager.class);
    private final OfBizDelegator ofBizDelegator;
    private final WorkflowManager workflowManager;
    private final AssociationManager associationManager;
    private final UserAssociationStore userAssociationStore;
    private final IssueUpdater issueUpdater;
    private IssueDeleteHelper issueDeleteHelper;
    private FieldManager fieldManager;
    private FieldLayoutManager fieldLayoutManager;
    private final PermissionManager permissionManager;
    private final Map<String, Object> unassignedCondition = Collections.singletonMap("assignee", null);

    public DefaultIssueManager(OfBizDelegator ofBizDelegator, WorkflowManager workflowManager, AssociationManager associationManager, UserAssociationStore userAssociationStore, IssueUpdater issueUpdater, PermissionManager permissionManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.workflowManager = workflowManager;
        this.associationManager = associationManager;
        this.userAssociationStore = userAssociationStore;
        this.issueUpdater = issueUpdater;
        this.permissionManager = permissionManager;
    }

    public GenericValue getIssue(Long id) throws DataAccessException {
        if (id == null) {
            return null;
        }
        return this.ofBizDelegator.findById("Issue", id);
    }

    public GenericValue getIssue(String key) throws GenericEntityException {
        if (key == null) {
            return null;
        }
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("Issue", EasyMap.build((Object)"key", (Object)key)));
    }

    public List<GenericValue> getIssues(Collection<Long> ids) {
        ArrayList<EntityExpr> entityExpressions = new ArrayList<EntityExpr>();
        List unsortedIssues = null;
        int batchSize = DefaultOfBizDelegator.getQueryBatchSize();
        int i = 0;
        for (Long issueId : ids) {
            entityExpressions.add(new EntityExpr("id", EntityOperator.EQUALS, (Object)issueId));
            if (++i < batchSize) continue;
            if (unsortedIssues == null) {
                unsortedIssues = this.ofBizDelegator.findByOr("Issue", entityExpressions, null);
            } else {
                unsortedIssues.addAll(this.ofBizDelegator.findByOr("Issue", entityExpressions, null));
            }
            entityExpressions = new ArrayList();
            i = 0;
        }
        if (!entityExpressions.isEmpty()) {
            if (unsortedIssues == null) {
                unsortedIssues = this.ofBizDelegator.findByOr("Issue", entityExpressions, null);
            } else {
                unsortedIssues.addAll(this.ofBizDelegator.findByOr("Issue", entityExpressions, null));
            }
        }
        return this.getIssuesSortedByIds(unsortedIssues, ids);
    }

    public List<Issue> getIssueObjects(Collection<Long> ids) {
        return Lists.transform(this.getIssues(ids), (Function)new Function<GenericValue, Issue>(){

            public Issue apply(@Nullable GenericValue from) {
                return DefaultIssueManager.this.getIssueFactory().getIssue(from);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> getIssueIdsForProject(Long projectId) throws GenericEntityException {
        if (projectId == null) {
            throw new NullPointerException("Project Id cannot be null.");
        }
        EntityListIterator issueIterator = null;
        ArrayList<Long> issueIds = new ArrayList<Long>();
        try {
            issueIterator = ((DelegatorInterface)ComponentAccessor.getComponent(DelegatorInterface.class)).findListIteratorByCondition("Issue", (EntityCondition)new EntityFieldMap(EasyMap.build((Object)"project", (Object)projectId), EntityOperator.AND), (Collection)EasyList.build((Object)"id"), null);
            GenericValue issueIdGV = issueIterator.next();
            while (issueIdGV != null) {
                issueIds.add(issueIdGV.getLong("id"));
                issueIdGV = issueIterator.next();
            }
        }
        finally {
            if (issueIterator != null) {
                issueIterator.close();
            }
        }
        return issueIds;
    }

    public long getIssueCountForProject(Long projectId) {
        Assertions.notNull((String)"projectId", (Object)projectId);
        EntityFieldMap condition = new EntityFieldMap(EasyMap.build((Object)"project", (Object)projectId), EntityOperator.AND);
        GenericValue countGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByCondition("IssueCount", (EntityCondition)condition, Collections.singletonList("count"), Collections.emptyList()));
        long count = countGV.getLong("count");
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnassignedIssues() {
        OfBizListIterator unassignedIssuesIt = this.ofBizDelegator.findListIteratorByCondition("Issue", (EntityCondition)new EntityFieldMap(this.unassignedCondition, EntityOperator.EQUALS), null, (Collection)ImmutableList.of((Object)"id"), null, EntityFindOptions.findOptions().maxResults(1));
        try {
            boolean bl = unassignedIssuesIt.next() != null;
            return bl;
        }
        finally {
            unassignedIssuesIt.close();
        }
    }

    public long getUnassignedIssueCount() {
        List unassignedCount = this.ofBizDelegator.findByCondition("IssueCountByAssignee", (EntityCondition)new EntityFieldMap(this.unassignedCondition, EntityOperator.EQUALS), (Collection)ImmutableList.of((Object)"count"), null);
        return EntityUtil.getOnly((List)unassignedCount).getLong("count");
    }

    private List<GenericValue> getIssuesSortedByIds(Collection<GenericValue> unsortedIssues, Collection<Long> ids) {
        HashMap<Long, GenericValue> idToIssue = new HashMap<Long, GenericValue>();
        for (GenericValue issue : unsortedIssues) {
            idToIssue.put(issue.getLong("id"), issue);
        }
        ArrayList<GenericValue> sortedIssues = new ArrayList<GenericValue>();
        for (Long id : ids) {
            sortedIssues.add((GenericValue)idToIssue.get(id));
        }
        return sortedIssues;
    }

    public GenericValue getIssueByWorkflow(Long wfid) throws GenericEntityException {
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("Issue", EasyMap.build((Object)"workflowId", (Object)wfid)));
    }

    public MutableIssue getIssueObjectByWorkflow(Long workflowId) throws GenericEntityException {
        return this.getIssueObject(this.getIssueByWorkflow(workflowId));
    }

    public MutableIssue getIssueObject(Long id) throws DataAccessException {
        GenericValue issueGV = this.getIssue(id);
        if (issueGV == null) {
            return null;
        }
        return this.getIssueObject(issueGV);
    }

    public MutableIssue getIssueObject(String key) throws DataAccessException {
        try {
            GenericValue issueGV = this.getIssue(key);
            if (issueGV == null) {
                return null;
            }
            return this.getIssueObject(issueGV);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<GenericValue> getEntitiesByIssue(String relationName, GenericValue issue) throws GenericEntityException {
        if (relationName.equals("IssueComponent")) {
            return this.associationManager.getSinkFromSource(issue, "Component", relationName, false);
        }
        if (relationName.equals("IssueFixVersion")) {
            return this.associationManager.getSinkFromSource(issue, "Version", relationName, false);
        }
        if (relationName.equals("IssueVersion")) {
            return this.associationManager.getSinkFromSource(issue, "Version", relationName, false);
        }
        if (relationName.equals("IssueChangeGroups")) {
            return issue.getRelatedCache("ChildChangeGroup");
        }
        if (relationName.equals("IssueWorkflowHistory")) {
            return this.workflowManager.makeWorkflow((String)null).getHistorySteps(issue.getLong("workflowId").longValue());
        }
        if (relationName.equals("IssueComments")) {
            return issue.getRelatedByAnd("ChildAction", MapBuilder.build((Object)"type", (Object)"comment"));
        }
        if (relationName.equals("IssueWorklog")) {
            return issue.getRelated("ChildWorklog");
        }
        if (relationName.equals("IssueLinksInward")) {
            return this.ofBizDelegator.findByAnd("IssueLink", MapBuilder.build((Object)"destination", (Object)issue.getLong("id")));
        }
        if (relationName.equals("IssueLinksOutward")) {
            return this.ofBizDelegator.findByAnd("IssueLink", MapBuilder.build((Object)"source", (Object)issue.getLong("id")));
        }
        if (relationName.equals("IssueCustomFieldValues")) {
            return this.ofBizDelegator.findByAnd("CustomFieldValue", MapBuilder.build((Object)"issue", (Object)issue.getLong("id")));
        }
        return Collections.emptyList();
    }

    public List<GenericValue> getEntitiesByIssueObject(String relationName, Issue issue) throws GenericEntityException {
        return this.getEntitiesByIssue(relationName, issue.getGenericValue());
    }

    public List<GenericValue> getIssuesByEntity(String relationName, GenericValue entity) throws GenericEntityException {
        return this.associationManager.getSourceFromSink(entity, "Issue", relationName, false);
    }

    public List<Issue> getIssueObjectsByEntity(String relationName, GenericValue entity) throws GenericEntityException {
        return Lists.transform(this.getIssuesByEntity(relationName, entity), (Function)new Function<GenericValue, Issue>(){

            public Issue apply(@Nullable GenericValue from) {
                return DefaultIssueManager.this.getIssueFactory().getIssue(from);
            }
        });
    }

    public GenericValue createIssue(User remoteUser, Map<String, Object> fields) throws CreateException {
        return this.createIssue(remoteUser != null ? remoteUser.getName() : null, fields);
    }

    public GenericValue createIssue(User remoteUser, Issue issue) throws CreateException {
        try {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("issue", issue);
            MutableIssue originalIssueGV = ComponentAccessor.getIssueManager().getIssueObject(issue.getId());
            fields.put("originalissueobject", originalIssueGV);
            GenericValue issueGV = this.workflowManager.createIssue(remoteUser != null ? remoteUser.getName() : null, fields);
            return issueGV;
        }
        catch (WorkflowException workflowException) {
            Throwable cause = workflowException.getCause();
            if (cause instanceof InvalidInputException) {
                throw new CreateException("Error occurred while creating issue through workflow: " + cause.getMessage(), (Exception)((Object)((InvalidInputException)cause)));
            }
            throw new CreateException((Exception)((Object)workflowException));
        }
    }

    public List<GenericValue> getProjectIssues(GenericValue project) throws GenericEntityException {
        return project.getRelated("ChildIssue");
    }

    public boolean isEditable(Issue issue) {
        return this.workflowManager.isEditable(issue);
    }

    public boolean isEditable(Issue issue, User user) {
        return this.isEditable(issue) && this.permissionManager.hasPermission(12, issue, user);
    }

    public GenericValue createIssue(String remoteUserName, Map<String, Object> fields) throws CreateException {
        try {
            GenericValue issue = this.workflowManager.createIssue(remoteUserName, fields);
            return issue;
        }
        catch (WorkflowException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof InvalidInputException) {
                throw new CreateException("Error occurred while creating issue through workflow: " + cause.getMessage(), (Exception)((Object)((InvalidInputException)cause)));
            }
            throw new CreateException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Issue createIssueObject(String remoteUserName, Map<String, Object> fields) throws CreateException {
        return this.getIssueFactory().getIssue(this.createIssue(remoteUserName, fields));
    }

    public Issue createIssueObject(User remoteUser, Map<String, Object> fields) throws CreateException {
        return this.getIssueFactory().getIssue(this.createIssue(remoteUser, fields));
    }

    public Issue createIssueObject(User remoteUser, Issue issue) throws CreateException {
        return this.getIssueFactory().getIssue(this.createIssue(remoteUser, issue));
    }

    public List<Issue> getVotedIssues(User user) throws GenericEntityException {
        List<GenericValue> issueGVs = this.userAssociationStore.getSinksFromUser("VoteIssue", user, "Issue");
        IssueUtils.filterIssues(issueGVs, new NoBrowsePermissionPredicate(user));
        return this.getIssueObjectsFromGVs(issueGVs);
    }

    public List<Issue> getVotedIssuesOverrideSecurity(User user) throws GenericEntityException {
        List<GenericValue> issueGVs = this.userAssociationStore.getSinksFromUser("VoteIssue", user, "Issue");
        return this.getIssueObjectsFromGVs(issueGVs);
    }

    private List<Issue> getIssueObjectsFromGVs(List<GenericValue> issueGVs) {
        Collections.sort(issueGVs, IssueKeyComparator.COMPARATOR);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (GenericValue issue : issueGVs) {
            issues.add((Issue)this.getIssueObject(issue));
        }
        return issues;
    }

    public List<User> getWatchers(Issue issue) {
        return this.userAssociationStore.getUsersFromSink("WatchIssue", issue.getGenericValue());
    }

    public List<Issue> getWatchedIssues(User user) {
        List<GenericValue> issueGVs = this.userAssociationStore.getSinksFromUser("WatchIssue", user, "Issue");
        IssueUtils.filterIssues(issueGVs, new NoBrowsePermissionPredicate(user));
        return this.getIssueObjectsFromGVs(issueGVs);
    }

    public List<Issue> getWatchedIssuesOverrideSecurity(User user) {
        List<GenericValue> issueGVs = this.userAssociationStore.getSinksFromUser("WatchIssue", user, "Issue");
        return this.getIssueObjectsFromGVs(issueGVs);
    }

    public Issue updateIssue(User user, MutableIssue issue, EventDispatchOption eventDispatchOption, boolean sendMail) {
        GenericValue originalIssueGV = issue.getGenericValue();
        StringBuffer modifiedText = new StringBuffer();
        DefaultIssueChangeHolder issueChangeHolder = this.updateFieldValues(issue, modifiedText);
        issue.resetModifiedFields();
        this.doUpdate(issue, originalIssueGV, eventDispatchOption, user, sendMail, issueChangeHolder);
        return issue;
    }

    protected void doUpdate(MutableIssue issue, GenericValue originalIssueGV, EventDispatchOption eventDispatchOption, User user, boolean sendMail, DefaultIssueChangeHolder issueChangeHolder) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue.getGenericValue(), originalIssueGV, eventDispatchOption.getEventTypeId(), user, sendMail, true);
        issueUpdateBean.setComment(issueChangeHolder.getComment());
        issueUpdateBean.setChangeItems((Collection)issueChangeHolder.getChangeItems());
        issueUpdateBean.setDispatchEvent(eventDispatchOption.isEventBeingSent());
        issueUpdateBean.setParams(MapBuilder.newBuilder((Object)"eventsource", (Object)"action").toMutableMap());
        this.issueUpdater.doUpdate(issueUpdateBean, false);
    }

    protected DefaultIssueChangeHolder updateFieldValues(MutableIssue issue, StringBuffer modifiedText) {
        DefaultIssueChangeHolder issueChangeHolder = new DefaultIssueChangeHolder();
        Map modifiedFields = issue.getModifiedFields();
        for (String fieldId : modifiedFields.keySet()) {
            if (!this.getFieldManager().isOrderableField(fieldId)) continue;
            OrderableField field = this.getFieldManager().getOrderableField(fieldId);
            FieldLayoutItem fieldLayoutItem = this.getFieldLayoutManager().getFieldLayout((Issue)issue).getFieldLayoutItem(field);
            ModifiedValue modifiedValue = (ModifiedValue)modifiedFields.get(fieldId);
            field.updateValue(fieldLayoutItem, (Issue)issue, modifiedValue, (IssueChangeHolder)issueChangeHolder);
            if (!"description".equals(fieldId) && !"environment".equals(fieldId)) continue;
            modifiedText.append(modifiedValue != null ? modifiedValue.getNewValue() : "").append(" ");
        }
        return issueChangeHolder;
    }

    public void deleteIssue(User user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssue(user, issue, eventDispatchOption, sendMail);
    }

    public void deleteIssue(User user, MutableIssue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssue(user, (Issue)issue, eventDispatchOption, sendMail);
    }

    public void deleteIssueNoEvent(Issue issue) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssueNoEvent(issue);
    }

    public void deleteIssueNoEvent(MutableIssue issue) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssueNoEvent((Issue)issue);
    }

    private MutableIssue getIssueObject(GenericValue issueGV) {
        if (issueGV == null) {
            return null;
        }
        return this.getIssueFactory().getIssue(issueGV);
    }

    private IssueFactory getIssueFactory() {
        return ComponentAccessor.getIssueFactory();
    }

    FieldLayoutManager getFieldLayoutManager() {
        if (this.fieldLayoutManager == null) {
            this.fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        }
        return this.fieldLayoutManager;
    }

    FieldManager getFieldManager() {
        if (this.fieldManager == null) {
            this.fieldManager = ComponentManager.getInstance().getFieldManager();
        }
        return this.fieldManager;
    }

    IssueDeleteHelper getIssueDeleteHelper() {
        if (this.issueDeleteHelper == null) {
            this.issueDeleteHelper = ComponentManager.getComponentInstanceOfType(IssueDeleteHelper.class);
        }
        return this.issueDeleteHelper;
    }
}

