/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.AbstractLanguageAnalyser;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.th.ThaiWordFilter;
import org.apache.lucene.util.Version;

public class ThaiAnalyzer
extends AbstractLanguageAnalyser {
    private final Set<?> stopWords;
    private final Version matchVersion;

    public ThaiAnalyzer(Version matchVersion, boolean indexing) {
        super(indexing);
        this.matchVersion = matchVersion;
        this.stopWords = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        ClassicTokenizer result = new ClassicTokenizer(this.matchVersion, reader);
        result = new StandardFilter(this.matchVersion, (TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopWords);
        result = new ThaiWordFilter(this.matchVersion, (TokenStream)result);
        return result;
    }
}

