/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.index.CompositeResultBuilder;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.IndexingStrategy;
import com.atlassian.jira.index.MultiThreadedIndexingConfiguration;
import com.atlassian.jira.index.MultiThreadedIndexingStrategy;
import com.atlassian.jira.index.Operations;
import com.atlassian.jira.index.SimpleIndexingStrategy;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.ChangeHistoryDocumentFactory;
import com.atlassian.jira.issue.index.CommentDocumentFactory;
import com.atlassian.jira.issue.index.DefaultChangeHistoryDocumentFactory;
import com.atlassian.jira.issue.index.DefaultCommentDocumentFactory;
import com.atlassian.jira.issue.index.DefaultIssueDocumentFactory;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IssueDocumentFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.GuardedBy;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;

public class DefaultIssueIndexer
implements IssueIndexer {
    private final CommentRetriever commentRetriever;
    private final ChangeHistoryRetriever changeHistoryRetriever;
    private final MultiThreadedIndexingConfiguration multiThreadedIndexingConfiguration;
    private final Lifecycle lifecycle;
    private final IssueDocumentFactory issueDocumentBuilder = new DefaultIssueDocumentFactory();
    private final CommentDocumentFactory commentDocumentFactory = new DefaultCommentDocumentFactory();
    private final CommentDocumentBuilder commentDocumentBuilder = new CommentDocumentBuilder();
    private final ChangeHistoryDocumentBuilder changeHistoryDocumentBuilder = new ChangeHistoryDocumentBuilder();
    private final IndexingStrategy simpleIndexingStrategy = new SimpleIndexingStrategy();
    private final DocumentCreationStrategy documentCreationStrategy = new IssueLockDocumentCreationStrategy();

    public DefaultIssueIndexer(@NotNull IndexDirectoryFactory indexDirectoryFactory, @NotNull CommentRetriever commentRetriever, @NotNull ChangeHistoryRetriever changeHistoryRetriever, @NotNull ApplicationProperties applicationProperties) {
        this.lifecycle = new Lifecycle(indexDirectoryFactory);
        this.commentRetriever = (CommentRetriever)Assertions.notNull((String)"commentRetriever", (Object)commentRetriever);
        this.changeHistoryRetriever = (ChangeHistoryRetriever)Assertions.notNull((String)"changeHistoryReriever", (Object)changeHistoryRetriever);
        this.multiThreadedIndexingConfiguration = new PropertiesAdapter(applicationProperties);
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result deindexIssues(@NotNull EnclosedIterable<Issue> issues, @NotNull Context context) {
        return DefaultIssueIndexer.perform(issues, this.simpleIndexingStrategy, context, new IndexOperation(){

            @Override
            public Index.Result perform(Issue issue, Context.Task task) {
                Term issueTerm = DefaultIssueIndexer.this.issueDocumentBuilder.getIdentifyingTerm(issue);
                Index.Operation delete = Operations.newDelete(issueTerm, Index.UpdateMode.INTERACTIVE);
                Index.Operation onCompletion = Operations.newCompletionDelegate(delete, new TaskCompleter(task));
                CompositeResultBuilder results = new CompositeResultBuilder();
                results.add(DefaultIssueIndexer.this.lifecycle.getIssueIndex().perform(onCompletion));
                results.add(DefaultIssueIndexer.this.lifecycle.getCommentIndex().perform(delete));
                results.add(DefaultIssueIndexer.this.lifecycle.getChangeHistoryIndex().perform(delete));
                return results.toResult();
            }
        });
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result indexIssues(@NotNull EnclosedIterable<Issue> issues, @NotNull Context context) {
        return DefaultIssueIndexer.perform(issues, this.simpleIndexingStrategy, context, new IndexIssuesOperation(Index.UpdateMode.INTERACTIVE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="external index write lock")
    public Index.Result indexIssuesBatchMode(@NotNull EnclosedIterable<Issue> issues, @NotNull Context context) {
        if (issues.size() < this.multiThreadedIndexingConfiguration.minimumBatchSize()) {
            return this.indexIssues(issues, context);
        }
        this.lifecycle.close();
        this.lifecycle.setMode(IndexDirectoryFactory.Mode.DIRECT);
        try {
            Index.Result result = DefaultIssueIndexer.perform(issues, (IndexingStrategy)new MultiThreadedIndexingStrategy(this.simpleIndexingStrategy, this.multiThreadedIndexingConfiguration, "IssueIndexer"), context, new IndexIssuesOperation(Index.UpdateMode.BATCH));
            return result;
        }
        finally {
            this.lifecycle.close();
            this.lifecycle.setMode(IndexDirectoryFactory.Mode.QUEUED);
        }
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result reindexIssues(@NotNull EnclosedIterable<Issue> issues, @NotNull Context context, final boolean reIndexComments, final boolean reIndexChangeHistory, final boolean conditionalUpdate) {
        return DefaultIssueIndexer.perform(issues, this.simpleIndexingStrategy, context, new IndexOperation(){

            @Override
            public Index.Result perform(Issue issue, Context.Task task) {
                Index.UpdateMode mode = Index.UpdateMode.INTERACTIVE;
                Documents documents = DefaultIssueIndexer.this.documentCreationStrategy.get(issue, reIndexComments, reIndexChangeHistory);
                Term issueTerm = documents.getIdentifyingTerm();
                Index.Operation update = conditionalUpdate ? Operations.newConditionalUpdate(issueTerm, documents.getIssue(), mode, "updated") : Operations.newUpdate(issueTerm, documents.getIssue(), mode);
                Index.Operation onCompletion = Operations.newCompletionDelegate(update, new TaskCompleter(task));
                CompositeResultBuilder results = new CompositeResultBuilder();
                results.add(DefaultIssueIndexer.this.lifecycle.getIssueIndex().perform(onCompletion));
                if (reIndexComments) {
                    results.add(DefaultIssueIndexer.this.lifecycle.getCommentIndex().perform(Operations.newUpdate(issueTerm, documents.getComments(), mode)));
                }
                if (reIndexChangeHistory) {
                    results.add(DefaultIssueIndexer.this.lifecycle.getChangeHistoryIndex().perform(Operations.newUpdate(issueTerm, documents.getChanges(), mode)));
                }
                return results.toResult();
            }
        });
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result reindexComments(@NotNull Collection<Comment> comments, @NotNull Context context) {
        return DefaultIssueIndexer.perform(comments, this.simpleIndexingStrategy, context, new CommentOperation(){

            @Override
            public Index.Result perform(Comment comment, Context.Task task) {
                Index.UpdateMode mode = Index.UpdateMode.INTERACTIVE;
                Document document = (Document)DefaultIssueIndexer.this.commentDocumentFactory.get(comment);
                Term commentTerm = DefaultIssueIndexer.this.commentDocumentFactory.getIdentifyingTerm(comment);
                return DefaultIssueIndexer.this.lifecycle.getCommentIndex().perform(Operations.newUpdate(commentTerm, document, mode));
            }
        });
    }

    @Override
    public void deleteIndexes() {
        for (Index.Manager manager : this.lifecycle) {
            manager.deleteIndexDirectory();
        }
    }

    @Override
    public IndexSearcher getCommentSearcher() {
        return this.lifecycle.get(IndexDirectoryFactory.Name.COMMENT).getSearcher();
    }

    @Override
    public IndexSearcher getIssueSearcher() {
        return this.lifecycle.get(IndexDirectoryFactory.Name.ISSUE).getSearcher();
    }

    @Override
    public IndexSearcher getChangeHistorySearcher() {
        return this.lifecycle.get(IndexDirectoryFactory.Name.CHANGE_HISTORY).getSearcher();
    }

    @Override
    public Index.Result optimize() {
        CompositeResultBuilder builder = new CompositeResultBuilder();
        for (Index.Manager manager : this.lifecycle) {
            builder.add(manager.getIndex().perform(Operations.newOptimize()));
        }
        return builder.toResult();
    }

    @Override
    public void shutdown() {
        this.lifecycle.close();
    }

    @Override
    public List<String> getIndexPaths() {
        return this.lifecycle.getIndexPaths();
    }

    @Override
    public String getIndexRootPath() {
        return this.lifecycle.getIndexRootPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Index.Result perform(EnclosedIterable<Issue> issues, final IndexingStrategy strategy, final Context context, final IndexOperation operation) {
        try {
            Assertions.notNull((String)"issues", issues);
            final CompositeResultBuilder builder = new CompositeResultBuilder();
            issues.foreach((Consumer)new Consumer<Issue>(){

                public void consume(final Issue issue) {
                    final Context.Task task = context.start((Object)issue);
                    Index.Result result = (Index.Result)strategy.get(new Supplier<Index.Result>(){

                        public Index.Result get() {
                            return operation.perform(issue, task);
                        }
                    });
                    builder.add(result);
                }
            });
            Index.Result result = builder.toResult();
            return result;
        }
        finally {
            strategy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Index.Result perform(Iterable<Comment> comments, IndexingStrategy strategy, Context context, final CommentOperation operation) {
        try {
            Assertions.notNull((String)"comments", comments);
            CompositeResultBuilder builder = new CompositeResultBuilder();
            for (final Comment comment : comments) {
                final Context.Task task = context.start((Object)comment);
                Index.Result result = (Index.Result)strategy.get(new Supplier<Index.Result>(){

                    public Index.Result get() {
                        return operation.perform(comment, task);
                    }
                });
                builder.add(result);
            }
            Index.Result result = builder.toResult();
            return result;
        }
        finally {
            strategy.close();
        }
    }

    static class PropertiesAdapter
    implements MultiThreadedIndexingConfiguration {
        private final ApplicationProperties applicationProperties;

        PropertiesAdapter(ApplicationProperties applicationProperties) {
            this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        }

        @Override
        public int minimumBatchSize() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.issue.minbatchsize", (int)50);
        }

        @Override
        public int maximumQueueSize() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.issue.maxqueuesize", (int)1000);
        }

        @Override
        public int noOfThreads() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.issue.threads", (int)20);
        }
    }

    class IssueLockDocumentCreationStrategy
    implements DocumentCreationStrategy {
        private final com.atlassian.util.concurrent.Function<Issue, ManagedLock> lockManager = ManagedLocks.weakManagedLockFactory((com.atlassian.util.concurrent.Function)new Function<Issue, Integer>(){

            public Integer get(Issue issue) {
                return issue.getId().intValue();
            }
        });

        IssueLockDocumentCreationStrategy() {
        }

        @Override
        public Documents get(final Issue issue, final boolean includeComments, final boolean includeChangeHistory) {
            return (Documents)((ManagedLock)this.lockManager.get((Object)issue)).withLock((com.atlassian.util.concurrent.Supplier)new com.atlassian.util.concurrent.Supplier<Documents>(){

                public Documents get() {
                    List<Document> comments = includeComments ? DefaultIssueIndexer.this.commentDocumentBuilder.get(issue) : Collections.emptyList();
                    List<Document> changes = includeChangeHistory ? DefaultIssueIndexer.this.changeHistoryDocumentBuilder.get(issue) : Collections.emptyList();
                    return new Documents(issue, (Document)DefaultIssueIndexer.this.issueDocumentBuilder.get(issue), comments, changes);
                }
            });
        }
    }

    class ChangeHistoryDocumentBuilder
    implements Function<Issue, List<Document>> {
        private final ChangeHistoryDocumentFactory changeHistoryDocumentFactory = new DefaultChangeHistoryDocumentFactory();

        ChangeHistoryDocumentBuilder() {
        }

        public List<Document> get(Issue issue) {
            return CollectionUtil.transform((Iterable)((Iterable)DefaultIssueIndexer.this.changeHistoryRetriever.get(issue)), (Function)new Function<ChangeHistoryGroup, Document>(){

                public Document get(ChangeHistoryGroup changeHistory) {
                    return (Document)ChangeHistoryDocumentBuilder.this.changeHistoryDocumentFactory.get(changeHistory);
                }
            });
        }
    }

    class CommentDocumentBuilder
    implements Function<Issue, List<Document>> {
        CommentDocumentBuilder() {
        }

        public List<Document> get(Issue issue) {
            return CollectionUtil.transform((Iterable)((Iterable)DefaultIssueIndexer.this.commentRetriever.get(issue)), (Function)new Function<Comment, Document>(){

                public Document get(Comment comment) {
                    return (Document)DefaultIssueIndexer.this.commentDocumentFactory.get(comment);
                }
            });
        }
    }

    class Documents {
        private final Document issueDocument;
        private final List<Document> comments;
        private final List<Document> changes;
        private final Term term;

        Documents(Issue issue, Document issueDocument, List<Document> comments, List<Document> changes) {
            this.issueDocument = issueDocument;
            this.comments = Collections.unmodifiableList(comments);
            this.changes = Collections.unmodifiableList(changes);
            this.term = DefaultIssueIndexer.this.issueDocumentBuilder.getIdentifyingTerm(issue);
        }

        Document getIssue() {
            return this.issueDocument;
        }

        List<Document> getComments() {
            return this.comments;
        }

        List<Document> getChanges() {
            return this.changes;
        }

        Term getIdentifyingTerm() {
            return this.term;
        }
    }

    static interface DocumentCreationStrategy {
        public Documents get(Issue var1, boolean var2, boolean var3);
    }

    private static class TaskCompleter
    implements Runnable {
        private final Context.Task task;

        public TaskCompleter(Context.Task task) {
            this.task = task;
        }

        @Override
        public void run() {
            this.task.complete();
        }
    }

    private static interface CommentOperation {
        public Index.Result perform(Comment var1, Context.Task var2);
    }

    private static interface IndexOperation {
        public Index.Result perform(Issue var1, Context.Task var2);
    }

    private class IndexIssuesOperation
    implements IndexOperation {
        final Index.UpdateMode mode;

        IndexIssuesOperation(Index.UpdateMode mode) {
            this.mode = mode;
        }

        @Override
        public Index.Result perform(Issue issue, Context.Task task) {
            Map customFieldValueCache;
            Documents documents = DefaultIssueIndexer.this.documentCreationStrategy.get(issue, true, true);
            Index.Operation issueCreate = Operations.newCreate(documents.getIssue(), this.mode);
            Index.Operation onCompletion = Operations.newCompletionDelegate(issueCreate, new TaskCompleter(task));
            CompositeResultBuilder results = new CompositeResultBuilder();
            results.add(DefaultIssueIndexer.this.lifecycle.getIssueIndex().perform(onCompletion));
            if (!documents.getComments().isEmpty()) {
                Index.Operation commentsCreate = Operations.newCreate(documents.getComments(), this.mode);
                results.add(DefaultIssueIndexer.this.lifecycle.getCommentIndex().perform(commentsCreate));
            }
            if (!documents.getChanges().isEmpty()) {
                Index.Operation changeHistoryCreate = Operations.newCreate(documents.getChanges(), this.mode);
                results.add(DefaultIssueIndexer.this.lifecycle.getChangeHistoryIndex().perform(changeHistoryCreate));
            }
            if ((customFieldValueCache = (Map)JiraAuthenticationContextImpl.getRequestCache().get("jira.customfield.values.cache")) != null) {
                customFieldValueCache.clear();
            }
            return results.toResult();
        }
    }

    private static class Lifecycle
    implements Iterable<Index.Manager> {
        private final AtomicReference<Map<IndexDirectoryFactory.Name, Index.Manager>> ref = new AtomicReference();
        private final IndexDirectoryFactory factory;

        public Lifecycle(@NotNull IndexDirectoryFactory factory) {
            this.factory = (IndexDirectoryFactory)Assertions.notNull((String)"factory", (Object)factory);
        }

        @Override
        public Iterator<Index.Manager> iterator() {
            return this.open().values().iterator();
        }

        void close() {
            Map indexes = this.ref.getAndSet(null);
            if (indexes == null) {
                return;
            }
            for (Index.Manager manager : indexes.values()) {
                manager.close();
            }
        }

        Map<IndexDirectoryFactory.Name, Index.Manager> open() {
            Map<IndexDirectoryFactory.Name, Index.Manager> result = this.ref.get();
            while (result == null) {
                this.ref.compareAndSet(null, (Map<IndexDirectoryFactory.Name, Index.Manager>)this.factory.get());
                result = this.ref.get();
            }
            return result;
        }

        Index getIssueIndex() {
            return this.get(IndexDirectoryFactory.Name.ISSUE).getIndex();
        }

        Index getCommentIndex() {
            return this.get(IndexDirectoryFactory.Name.COMMENT).getIndex();
        }

        Index getChangeHistoryIndex() {
            return this.get(IndexDirectoryFactory.Name.CHANGE_HISTORY).getIndex();
        }

        Index.Manager get(IndexDirectoryFactory.Name key) {
            return this.open().get((Object)key);
        }

        List<String> getIndexPaths() {
            return this.factory.getIndexPaths();
        }

        String getIndexRootPath() {
            return this.factory.getIndexRootPath();
        }

        void setMode(IndexDirectoryFactory.Mode type) {
            this.factory.setIndexingMode(type);
        }
    }

    public static interface ChangeHistoryRetriever
    extends Function<Issue, List<ChangeHistoryGroup>> {
    }

    public static interface CommentRetriever
    extends Function<Issue, List<Comment>> {
    }
}

