/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.QueryContextConverter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.OptionUtils;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.KickassSearchContext;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class MultiSelectCustomFieldSearchInputTransformer
extends AbstractCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private final ClauseNames clauseNames;
    private final CustomField field;
    private final JqlOperandResolver jqlOperandResolver;
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;
    private final QueryContextConverter queryContextConverter;

    public MultiSelectCustomFieldSearchInputTransformer(String urlParameterName, ClauseNames clauseNames, CustomField field, JqlOperandResolver jqlOperandResolver, JqlSelectOptionsUtil jqlSelectOptionsUtil, QueryContextConverter queryContextConverter, CustomFieldInputHelper customFieldInputHelper) {
        super(field, urlParameterName, customFieldInputHelper);
        this.queryContextConverter = (QueryContextConverter)Assertions.notNull((String)"queryContextConverter", (Object)queryContextConverter);
        this.jqlSelectOptionsUtil = (JqlSelectOptionsUtil)Assertions.notNull((String)"jqlSelectOptionsUtil", (Object)jqlSelectOptionsUtil);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.field = (CustomField)Assertions.notNull((String)"field", (Object)field);
        this.clauseNames = (ClauseNames)Assertions.notNull((String)"clauseNames", (Object)clauseNames);
    }

    protected Clause getClauseFromParams(User user, CustomFieldParams params) {
        Collection searchValues = params.getAllValues();
        searchValues.removeAll(CollectionBuilder.newBuilder((Object[])new String[]{"-1", ""}).asCollection());
        if (!searchValues.isEmpty()) {
            ArrayList<String> termValues = new ArrayList<String>();
            for (String value : searchValues) {
                Long longValue = null;
                String transformedValue = value;
                longValue = OptionUtils.safeParseLong((String)value);
                Option option = this.jqlSelectOptionsUtil.getOptionById(longValue);
                if (option != null) {
                    transformedValue = option.getValue();
                }
                termValues.add(transformedValue);
            }
            if (termValues.size() > 0) {
                return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), termValues.toArray(new String[termValues.size()]));
            }
        }
        return null;
    }

    protected CustomFieldParams getParamsFromSearchRequest(User user, Query query, SearchContext searchContext) {
        if (query != null && query.getWhereClause() != null) {
            List literals;
            TerminalClause clause;
            SimpleNavigatorCollectorVisitor visitor = new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
            query.getWhereClause().accept((ClauseVisitor)visitor);
            if (visitor.isValid() && visitor.getClauses().size() == 1 && this.isValidOperatorForFitness((clause = (TerminalClause)visitor.getClauses().get(0)).getOperator()) && (literals = this.jqlOperandResolver.getValues(user, clause.getOperand(), clause)) != null && !literals.contains(new QueryLiteral())) {
                HashSet<String> valuesAsStrings = new HashSet<String>();
                QueryContext queryContext = this.queryContextConverter.getQueryContext(searchContext);
                for (QueryLiteral literal : literals) {
                    List<Option> options = null;
                    options = this.isNewIssueNavigator() ? this.jqlSelectOptionsUtil.getOptions(this.field, literal, false) : this.jqlSelectOptionsUtil.getOptions(this.field, queryContext, literal, false);
                    if (options.isEmpty()) {
                        return null;
                    }
                    for (Option option : options) {
                        valuesAsStrings.add(option.getOptionId().toString());
                    }
                }
                if (valuesAsStrings.isEmpty()) {
                    return null;
                }
                return new CustomFieldParamsImpl(this.getCustomField(), valuesAsStrings);
            }
        }
        return null;
    }

    protected boolean isValidOperatorForFitness(Operator operator) {
        return operator == Operator.EQUALS || operator == Operator.IS || operator == Operator.IN;
    }

    public boolean doRelevantClausesFitFilterForm(User user, Query query, SearchContext searchContext) {
        return this.getParamsFromSearchRequest(user, query, searchContext) != null;
    }

    public void validateParams(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
    }

    private boolean isNewIssueNavigator() {
        KickassSearchContext kickassSearchContext = (KickassSearchContext)ComponentAccessor.getComponent(KickassSearchContext.class);
        return kickassSearchContext != null && kickassSearchContext.isEnabled();
    }
}

