/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.LazyLoadedOption;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.option.OptionsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.util.CollectionReorderer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class DefaultOptionsManager
implements OptionsManager {
    public static final String ENTITY_CONFIG_ID = "customfieldconfig";
    private static final String DB_ASC_SUFFIX = " ASC";
    private static final Logger log = Logger.getLogger(DefaultOptionsManager.class);
    private static final List<String> ORDER_BY_LIST = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"parentoptionid ASC", "sequence ASC"}));
    private static final String TABLE_CUSTOMFIELD_OPTION = "CustomFieldOption";
    private final OfBizDelegator delegator;
    private final CollectionReorderer<Option> reorderer;
    private final FieldConfigManager fieldConfigManager;

    public DefaultOptionsManager(OfBizDelegator delegator, CollectionReorderer<Option> reorderer, FieldConfigManager fieldConfigManager) {
        this.delegator = delegator;
        this.reorderer = reorderer;
        this.fieldConfigManager = fieldConfigManager;
    }

    public Options getOptions(FieldConfig fieldConfig) {
        if (fieldConfig != null) {
            Map<String, Object> params = new PrimitiveMap.Builder().add(ENTITY_CONFIG_ID, fieldConfig.getId()).toMap();
            return new OptionsImpl(this.convertGVsToOptions(this.delegator.findByAnd(TABLE_CUSTOMFIELD_OPTION, params, ORDER_BY_LIST)), fieldConfig, this.reorderer, this);
        }
        return null;
    }

    public void setRootOptions(FieldConfig fieldConfig, Options options) {
        this.removeCustomFieldConfigOptions(fieldConfig);
        if (options != null) {
            int counter = 0;
            for (Option o : options) {
                if (!(o instanceof Option)) {
                    log.error("Can only set options for 'Option'.  This value was " + o == null ? null : o.getClass().getName());
                    return;
                }
                Option option = o;
                Map<String, Object> params = new PrimitiveMap.Builder().add("customfield", fieldConfig.getCustomField().getIdAsLong()).add(ENTITY_CONFIG_ID, fieldConfig.getId()).add("value", option.getValue()).add("parentoptionid", (String)null).add("sequence", new Long(counter)).toMap();
                this.delegator.createValue(TABLE_CUSTOMFIELD_OPTION, params);
                ++counter;
            }
        }
    }

    public void removeCustomFieldOptions(CustomField customField) {
        this.delegator.removeByAnd(TABLE_CUSTOMFIELD_OPTION, EasyMap.build((Object)"customfield", (Object)customField.getIdAsLong()));
    }

    public void removeCustomFieldConfigOptions(FieldConfig fieldConfig) {
        this.delegator.removeByAnd(TABLE_CUSTOMFIELD_OPTION, EasyMap.build((Object)ENTITY_CONFIG_ID, (Object)fieldConfig.getId()));
    }

    public void updateOptions(Collection<Option> options) {
        if (options != null) {
            for (Option option : options) {
                option.store();
            }
        }
    }

    public Option createOption(FieldConfig fieldConfig, Long parentOptionId, Long sequence, String value) {
        Map<String, Object> params = new PrimitiveMap.Builder().add("customfield", fieldConfig.getCustomField().getIdAsLong()).add(ENTITY_CONFIG_ID, fieldConfig.getId()).add("value", value).add("parentoptionid", parentOptionId).add("sequence", sequence).add("disabled", "N").toMap();
        GenericValue gv = this.delegator.createValue(TABLE_CUSTOMFIELD_OPTION, params);
        if (gv != null) {
            return new LazyLoadedOption(gv, this, this.fieldConfigManager);
        }
        return null;
    }

    public void deleteOptionAndChildren(Option option) {
        List<GenericValue> gvToRemove = this.convertOptionsToGV(option.retrieveAllChildren(null));
        gvToRemove.add(option.getGenericValue());
        this.delegator.removeAll(gvToRemove);
    }

    public List<Option> getAllOptions() {
        List optionGVs = this.delegator.findAll(TABLE_CUSTOMFIELD_OPTION, ORDER_BY_LIST);
        return this.convertGVsToOptions(optionGVs);
    }

    public void disableOption(Option option) {
        option.setDisabled(Boolean.TRUE);
        option.store();
    }

    public void enableOption(Option option) {
        option.setDisabled(Boolean.FALSE);
        option.store();
    }

    public void setValue(Option option, String value) {
        option.setValue(value);
        option.store();
    }

    public List<Option> findByOptionValue(String value) {
        List<Option> allOptions = this.getAllOptions();
        ArrayList<Option> matchingOptions = new ArrayList<Option>();
        for (Option allOption : allOptions) {
            if (!allOption.getValue().equalsIgnoreCase(value)) continue;
            matchingOptions.add(allOption);
        }
        return matchingOptions;
    }

    public Option findByOptionId(Long optionId) {
        GenericValue option = this.delegator.findById(TABLE_CUSTOMFIELD_OPTION, optionId);
        return option == null ? null : new LazyLoadedOption(option, this, this.fieldConfigManager);
    }

    public List<Option> findByParentId(Long parentOptionId) {
        List optionGVs = this.delegator.findByAnd(TABLE_CUSTOMFIELD_OPTION, EasyMap.build((Object)"parentoptionid", (Object)parentOptionId), ORDER_BY_LIST);
        return this.convertGVsToOptions(optionGVs);
    }

    private List<GenericValue> convertOptionsToGV(List<Option> options) {
        return new ArrayList<GenericValue>(CollectionUtil.transform(options, (Function)new OptionToGenericValue()));
    }

    List<Option> convertGVsToOptions(List<GenericValue> optionGvs) {
        return new ArrayList<Option>(CollectionUtil.transform(optionGvs, (Function)new GenericValueToOption()));
    }

    private static final class OptionToGenericValue
    implements Function<Option, GenericValue> {
        private OptionToGenericValue() {
        }

        public GenericValue get(Option option) {
            return option.getGenericValue();
        }
    }

    private final class GenericValueToOption
    implements Function<GenericValue, Option> {
        private GenericValueToOption() {
        }

        public Option get(GenericValue input) {
            return new LazyLoadedOption(input, DefaultOptionsManager.this, DefaultOptionsManager.this.fieldConfigManager);
        }
    }

    private static final class Entity {
        static final String ID = "id";
        static final String CONFIG_ID = "customfieldconfig";
        static final String PARENT_OPTION = "parentoptionid";
        static final String ISSUE_VALUE = "value";
        static final String CUSTOMFIELD_ID = "customfield";
        static final String SEQUENCE = "sequence";
        static final String DISABLED = "disabled";

        private Entity() {
        }
    }
}

