/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.SelectCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.GroupSelectorField;
import com.atlassian.jira.issue.customfields.MultipleSettableCustomFieldType;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.SettableOptionsConfigItem;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.MultiSelectCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.OptionUtils;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.CustomFieldOptionJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class MultiSelectCFType
extends AbstractMultiCFType<Option>
implements MultipleSettableCustomFieldType<Collection<Option>, Option>,
SortableCustomField<List<String>>,
GroupSelectorField,
ProjectImportableCustomField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations {
    public static final String COMMA_REPLACEMENT = "&#44;";
    private static final Logger log = Logger.getLogger(MultiSelectCFType.class);
    private final ProjectCustomFieldImporter projectCustomFieldImporter;
    private final OptionsManager optionsManager;
    private final JiraBaseUrls jiraBaseUrls;

    public MultiSelectCFType(OptionsManager optionsManager, CustomFieldValuePersister valuePersister, GenericConfigManager genericConfigManager, JiraBaseUrls jiraBaseUrls) {
        super(valuePersister, genericConfigManager);
        this.optionsManager = optionsManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.projectCustomFieldImporter = new SelectCustomFieldImporter();
    }

    public Set<Long> remove(CustomField field) {
        this.optionsManager.removeCustomFieldOptions(field);
        return this.customFieldValuePersister.removeAllValues(field.getId());
    }

    public Options getOptions(FieldConfig fieldConfig, JiraContextNode jiraContextNode) {
        return this.optionsManager.getOptions(fieldConfig);
    }

    public void removeValue(CustomField field, Issue issue, Option option) {
        if (option != null) {
            this.customFieldValuePersister.removeValue(field, issue.getId(), PersistenceFieldType.TYPE_LIMITED_TEXT, (Object)option.getOptionId().toString());
        }
    }

    public Set<Long> getIssueIdsWithValue(CustomField field, Option option) {
        if (option != null) {
            return this.customFieldValuePersister.getIssueIdsWithValue(field, PersistenceFieldType.TYPE_LIMITED_TEXT, (Object)option.getOptionId().toString());
        }
        return Collections.emptySet();
    }

    @NotNull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    protected Option convertDbValueToType(Object dbValue) {
        return this.getSingularObjectFromString((String)dbValue);
    }

    protected Object convertTypeToDbValue(Option value) {
        return this.getStringFromSingularObject(value);
    }

    protected Comparator<Option> getTypeComparator() {
        return null;
    }

    public void setDefaultValue(FieldConfig fieldConfig, Collection<Option> value) {
        ArrayList<Long> defaultIds = new ArrayList<Long>();
        if (value != null) {
            for (Option o : value) {
                defaultIds.add(o.getOptionId());
            }
        }
        this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), defaultIds);
    }

    public Collection<Option> getDefaultValue(FieldConfig fieldConfig) {
        ArrayList<Option> options = new ArrayList<Option>();
        Collection optionIds = (Collection)this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (optionIds != null) {
            for (Long optionId : optionIds) {
                Option option = this.optionsManager.findByOptionId(optionId);
                if (option == null) continue;
                options.add(option);
            }
        }
        return options;
    }

    public Collection<Option> getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        Collection values = parameters.getAllValues();
        if (CustomFieldUtils.isCollectionNotEmpty((Collection)values)) {
            ArrayList<Option> options = new ArrayList<Option>();
            for (Object value : values) {
                options.add(this.getSingularObjectFromString((String)value));
            }
            return options;
        }
        return null;
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        return parameters.getValuesForNullKey();
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        Collection params = relevantParams.getAllValues();
        if (params == null || params.isEmpty()) {
            return;
        }
        CustomField customField = config.getCustomField();
        for (String paramValue : params) {
            if ("-1".equals(paramValue)) {
                if (params.size() <= 1) continue;
                errorCollectionToAddTo.addError(customField.getId(), this.getI18nBean().getText("admin.errors.cannot.specify.none"), ErrorCollection.Reason.VALIDATION_FAILED);
                continue;
            }
            Options options = this.optionsManager.getOptions(config);
            Long optionId = null;
            try {
                optionId = Long.valueOf(paramValue);
            }
            catch (NumberFormatException e) {
                errorCollectionToAddTo.addError(customField.getId(), this.getI18nBean().getText("admin.errors.invalid.value.passed.for.customfield", "'" + paramValue + "'", "'" + customField + "'", this.createValidOptionsString(options)), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            if (options.getOptionById(optionId) != null) continue;
            errorCollectionToAddTo.addError(customField.getId(), this.getI18nBean().getText("admin.errors.invalid.value.passed.for.customfield", "'" + paramValue + "'", "'" + customField + "'", this.createValidOptionsString(options)), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private String createValidOptionsString(Options options) {
        List rootOptions = options.getRootOptions();
        StringBuilder validOptions = new StringBuilder();
        Iterator optionIterator = rootOptions.iterator();
        while (optionIterator.hasNext()) {
            Option option = (Option)optionIterator.next();
            validOptions.append(option.getOptionId()).append("[").append(option.getValue()).append("]");
            if (!optionIterator.hasNext()) continue;
            validOptions.append(", ");
        }
        validOptions.append(", -1");
        return validOptions.toString();
    }

    public String getChangelogString(CustomField field, Collection<Option> value) {
        ArrayList<String> stringValues = new ArrayList<String>();
        if (value != null) {
            for (Option option : value) {
                stringValues.add(option.getValue());
            }
            return StringUtils.join(stringValues, (String)",");
        }
        return "";
    }

    public Option getSingularObjectFromString(String string) throws FieldValidationException {
        if ("-1".equals(string)) {
            return null;
        }
        return this.getOptionFromStringValue(string);
    }

    private Option getOptionFromStringValue(String selectValue) throws FieldValidationException {
        Long aLong = OptionUtils.safeParseLong((String)selectValue);
        if (aLong != null) {
            Option option = this.optionsManager.findByOptionId(aLong);
            if (option != null) {
                return option;
            }
            return null;
        }
        return null;
    }

    public String getStringFromSingularObject(Option optionObject) {
        if (optionObject == null) {
            return null;
        }
        return optionObject.getOptionId().toString();
    }

    @NotNull
    public List<FieldConfigItemType> getConfigurationItemTypes() {
        List configurationItemTypes = super.getConfigurationItemTypes();
        configurationItemTypes.add(new SettableOptionsConfigItem((CustomFieldType)this, this.optionsManager));
        return configurationItemTypes;
    }

    public int compare(@NotNull List<String> customFieldObjectValue1, @NotNull List<String> customFieldObjectValue2, FieldConfig fieldConfig) {
        Options options = this.getOptions(fieldConfig, null);
        if (options != null) {
            Long i1 = this.getLowestIndex(customFieldObjectValue1, options);
            Long i2 = this.getLowestIndex(customFieldObjectValue2, options);
            return i1.compareTo(i2);
        }
        log.info((Object)"No options were found.");
        return 0;
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    private Long getLowestIndex(List<String> l, Options options) {
        Long lowest = new Long(Long.MAX_VALUE);
        for (String name : l) {
            Option o = options.getOptionById(Long.valueOf(name));
            if (o == null || o.getSequence() == null || o.getSequence().compareTo(lowest) >= 0) continue;
            lowest = o.getSequence();
        }
        return lowest;
    }

    public static Collection<String> extractTransferObjectFromString(String value) {
        String[] a;
        if (value == null) {
            return null;
        }
        ArrayList<String> valuesToAdd = new ArrayList<String>();
        for (String s : a = StringUtils.split((String)StringUtils.replace((String)value, (String)"\\,", (String)COMMA_REPLACEMENT), (String)",")) {
            String s2 = StringUtils.replace((String)s, (String)COMMA_REPLACEMENT, (String)",");
            String s3 = StringUtils.trimToNull((String)s2);
            if (s3 == null) continue;
            valuesToAdd.add(s3);
        }
        return valuesToAdd;
    }

    public static String getStringFromTransferObject(Collection<String> collection) {
        if (collection != null) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                s = StringUtils.replace((String)s, (String)",", (String)"\\,");
                sb.append(s);
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        return null;
    }

    public boolean valuesEqual(Collection<Option> v1, Collection<Option> v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        return CollectionUtils.isEqualCollection(v1, v2);
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitMultiSelect(this);
        }
        return super.accept(visitor);
    }

    public Query getQueryForGroup(String fieldName, String groupName) {
        return new TermQuery(new Term(fieldName + "_raw", groupName));
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        FieldConfig config = ((CustomField)fieldTypeInfoContext.getOderableField()).getRelevantConfig(fieldTypeInfoContext.getIssueContext());
        Options options = this.optionsManager.getOptions(config);
        Collection optionBeans = CustomFieldOptionJsonBean.shortBeans((Collection)options, (JiraBaseUrls)this.jiraBaseUrls);
        return new FieldTypeInfo(optionBeans, null);
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.customArray((String)"string", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Collection valueFromIssue = this.getValueFromIssue(field, issue);
        if (valueFromIssue == null) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        return new FieldJsonRepresentation(new JsonData((Object)CustomFieldOptionJsonBean.shortBeans((Collection)valueFromIssue, (JiraBaseUrls)this.jiraBaseUrls)));
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        FieldConfig config = field.getRelevantConfig(issueCtx);
        Collection defaultValue = (Collection)field.getCustomFieldType().getDefaultValue(config);
        return defaultValue == null ? null : new JsonData((Object)CustomFieldOptionJsonBean.shortBeans((Collection)defaultValue, (JiraBaseUrls)this.jiraBaseUrls));
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new MultiSelectCustomFieldOperationsHandler(this.optionsManager, field, this.getI18nBean());
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitMultiSelect(MultiSelectCFType var1);
    }
}

