/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.AtomicSupplier;
import com.atlassian.jira.index.CloseableIndex;
import com.atlassian.jira.index.FutureResult;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.RuntimeInterruptedException;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.Tenant;
import com.atlassian.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;

class QueueingIndex
implements CloseableIndex {
    private final BlockingQueue<FutureOperation> queue = new LinkedBlockingQueue<FutureOperation>();
    private final Task task = new Task(this.queue);
    private final Tenant tenant = MultiTenantContext.getTenantReference().get();
    private final AtomicSupplier<Thread> indexerThread = new AtomicSupplier<Thread>(){

        @Override
        protected Thread create() {
            Thread thread = QueueingIndex.this.threadFactory.newThread(QueueingIndex.this.task);
            thread.start();
            return thread;
        }
    };
    private final CloseableIndex delegate;
    private final ThreadFactory threadFactory;

    QueueingIndex(@NotNull String name, @NotNull CloseableIndex delegate) {
        this(ThreadFactories.namedThreadFactory((String)Assertions.notNull((String)"name", (Object)name) + "-indexQueue"), delegate);
    }

    QueueingIndex(@NotNull ThreadFactory threadFactory, @NotNull CloseableIndex delegate) {
        this.threadFactory = (ThreadFactory)Assertions.notNull((String)"threadFactory", (Object)threadFactory);
        this.delegate = (CloseableIndex)Assertions.notNull((String)"delegate", (Object)delegate);
    }

    @Override
    public Index.Result perform(@NotNull Index.Operation operation) {
        FutureOperation future = new FutureOperation(operation);
        this.queue.add(future);
        this.check();
        return new FutureResult((Future<Index.Result>)((Object)future));
    }

    @Override
    public void close() {
        Thread thread = this.indexerThread.get();
        try {
            while (thread.isAlive()) {
                thread.interrupt();
                thread.join(100L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        finally {
            this.indexerThread.compareAndSetNull(thread);
            this.delegate.close();
        }
    }

    private void check() {
        Thread thread;
        while (!(thread = this.indexerThread.get()).isAlive()) {
            this.indexerThread.compareAndSetNull(thread);
        }
    }

    static class CompositeOperation
    extends Index.Operation {
        private final List<FutureOperation> operations;

        CompositeOperation(List<FutureOperation> operations) {
            this.operations = Collections.unmodifiableList(operations);
        }

        public void set(Index.Result result) {
            for (FutureOperation future : this.operations) {
                future.set(result);
            }
        }

        @Override
        void perform(Writer writer) throws IOException {
            for (FutureOperation future : this.operations) {
                future.operation.perform(writer);
            }
        }

        @Override
        Index.UpdateMode mode() {
            for (FutureOperation future : this.operations) {
                if (future.mode() != Index.UpdateMode.BATCH) continue;
                return Index.UpdateMode.BATCH;
            }
            return Index.UpdateMode.INTERACTIVE;
        }
    }

    static class FutureOperation
    extends SettableFuture<Index.Result> {
        private final Index.Operation operation;

        FutureOperation(Index.Operation operation) {
            this.operation = (Index.Operation)Assertions.notNull((String)"operation", (Object)operation);
        }

        Index.UpdateMode mode() {
            return this.operation.mode();
        }
    }

    class Task
    implements Runnable {
        private final BlockingQueue<FutureOperation> queue;

        Task(BlockingQueue<FutureOperation> queue) {
            this.queue = (BlockingQueue)Assertions.notNull((String)"queue", queue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                MultiTenantContext.getTenantReference().set(QueueingIndex.this.tenant, false);
                try {
                    this.index();
                }
                catch (InterruptedException e) {
                    break;
                }
                finally {
                    MultiTenantContext.getTenantReference().remove();
                }
            }
        }

        void index() throws InterruptedException {
            ArrayList<FutureOperation> list = new ArrayList<FutureOperation>();
            list.add(this.queue.take());
            this.queue.drainTo(list);
            CompositeOperation operation = new CompositeOperation(list);
            operation.set(QueueingIndex.this.delegate.perform(operation));
        }
    }
}

