/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.config.util.IndexWriterConfiguration;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.NotNull;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.IndexSearcher;

public interface Index {
    @NotNull
    public Result perform(@NotNull Operation var1);

    public static abstract class Operation {
        Operation() {
        }

        abstract void perform(@NotNull Writer var1) throws IOException;

        abstract UpdateMode mode();
    }

    public static enum UpdateMode {
        INTERACTIVE{

            @Override
            IndexWriterConfiguration.WriterSettings getWriterSettings(IndexWriterConfiguration configuration) {
                return configuration.getInteractiveSettings();
            }
        }
        ,
        BATCH{

            @Override
            IndexWriterConfiguration.WriterSettings getWriterSettings(IndexWriterConfiguration configuration) {
                return configuration.getBatchSettings();
            }
        };


        abstract IndexWriterConfiguration.WriterSettings getWriterSettings(IndexWriterConfiguration var1);
    }

    public static interface Manager
    extends Closeable {
        @NotNull
        public Index getIndex();

        @NotNull
        public IndexSearcher getSearcher();

        public boolean isIndexCreated();

        public void deleteIndexDirectory();
    }

    public static interface Result {
        public void await();

        public boolean await(long var1, TimeUnit var3);

        public boolean isDone();
    }
}

