/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.CloseableIndex;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.apache.lucene.search.IndexSearcher;

@ThreadSafe
class DefaultIndex
implements CloseableIndex {
    private final Engine engine;

    DefaultIndex(@NotNull Engine engine) {
        this.engine = (Engine)Assertions.notNull((String)"engine", (Object)engine);
    }

    @Override
    public Index.Result perform(@NotNull Index.Operation operation) {
        Assertions.notNull((String)"operation", (Object)operation);
        try {
            this.engine.write(operation);
            return new Success();
        }
        catch (IOException e) {
            return new Failure(e);
        }
        catch (Error e) {
            return new Failure(e);
        }
        catch (RuntimeException e) {
            return new Failure(e);
        }
    }

    @Override
    public void close() {
        this.engine.close();
    }

    private static class Failure
    implements Index.Result {
        private final Throwable failure;

        Failure(Error failure) {
            this.failure = failure;
        }

        Failure(RuntimeException failure) {
            this.failure = failure;
        }

        Failure(Exception failure) {
            this.failure = new RuntimeException(failure);
        }

        @Override
        public void await() {
            this.doThrow();
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) {
            return this.doThrow();
        }

        @Override
        public boolean isDone() {
            return true;
        }

        private boolean doThrow() {
            if (this.failure instanceof RuntimeException) {
                throw (RuntimeException)this.failure;
            }
            throw (Error)this.failure;
        }
    }

    private static class Success
    implements Index.Result {
        private Success() {
        }

        @Override
        public void await() {
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) {
            return true;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }

    static interface Engine
    extends Closeable {
        @NotNull
        public void write(@NotNull Index.Operation var1) throws IOException;

        @Override
        public void close();

        @NotNull
        public IndexSearcher getSearcher();

        public void clean();
    }
}

