/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.util;

import com.atlassian.jira.imports.project.util.ProjectImportTemporaryFiles;
import com.atlassian.jira.util.TempDirectoryUtil;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ProjectImportTemporaryFilesImpl
implements ProjectImportTemporaryFiles {
    private static final Logger log = Logger.getLogger(ProjectImportTemporaryFilesImpl.class);
    private final File parentDirectory;
    private final File issuesXmlFile;
    private final File customFieldValuesXmlFile;
    private final File issueRelatedEntitiesXmlFile;
    private final File changeItemEntitiesXmlFile;
    private final File fileAttachmentEntitiesXmlFile;

    public ProjectImportTemporaryFilesImpl(String projectKey) throws IOException {
        this.parentDirectory = TempDirectoryUtil.createTempDirectory("JiraProjectImport" + projectKey);
        this.issuesXmlFile = new File(this.parentDirectory, "Issues.xml");
        this.issuesXmlFile.createNewFile();
        this.customFieldValuesXmlFile = new File(this.parentDirectory, "CustomFieldValues.xml");
        this.customFieldValuesXmlFile.createNewFile();
        this.issueRelatedEntitiesXmlFile = new File(this.parentDirectory, "IssueRelatedEntities.xml");
        this.issueRelatedEntitiesXmlFile.createNewFile();
        this.changeItemEntitiesXmlFile = new File(this.parentDirectory, "ChangeItemEntities.xml");
        this.changeItemEntitiesXmlFile.createNewFile();
        this.fileAttachmentEntitiesXmlFile = new File(this.parentDirectory, "FileAttachmentEntities.xml");
        this.fileAttachmentEntitiesXmlFile.createNewFile();
    }

    @Override
    public File getParentDirectory() {
        return this.parentDirectory;
    }

    @Override
    public File getIssuesXmlFile() {
        return this.issuesXmlFile;
    }

    @Override
    public File getCustomFieldValuesXmlFile() {
        return this.customFieldValuesXmlFile;
    }

    @Override
    public File getIssueRelatedEntitiesXmlFile() {
        return this.issueRelatedEntitiesXmlFile;
    }

    @Override
    public File getChangeItemEntitiesXmlFile() {
        return this.changeItemEntitiesXmlFile;
    }

    @Override
    public File getFileAttachmentEntitiesXmlFile() {
        return this.fileAttachmentEntitiesXmlFile;
    }

    @Override
    public void deleteTempFiles() {
        this.deleteTemporaryFile(this.getChangeItemEntitiesXmlFile());
        this.deleteTemporaryFile(this.getCustomFieldValuesXmlFile());
        this.deleteTemporaryFile(this.getFileAttachmentEntitiesXmlFile());
        this.deleteTemporaryFile(this.getIssueRelatedEntitiesXmlFile());
        this.deleteTemporaryFile(this.getIssuesXmlFile());
        this.deleteTemporaryFile(this.getParentDirectory());
    }

    private void deleteTemporaryFile(File file) {
        if (!file.exists()) {
            return;
        }
        boolean deletedSuccessfully = file.delete();
        if (!deletedSuccessfully) {
            log.warn((Object)("Unable to delete temporary file '" + file.getAbsolutePath() + "'."));
        }
    }
}

