/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.AbstractImportPartitionHandler;
import java.io.PrintWriter;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.model.ModelEntity;

public class IssuePartitonHandler
extends AbstractImportPartitionHandler {
    private final BackupProject backupProject;
    private final ModelEntity modelEntity;
    private final PrintWriter printWriter;
    private int entityCount;

    public IssuePartitonHandler(BackupProject backupProject, PrintWriter printWriter, ModelEntity modelEntity, String encoding) {
        super(printWriter, encoding);
        this.assertModelEntityForName(modelEntity, "Issue");
        this.backupProject = backupProject;
        this.modelEntity = modelEntity;
        this.printWriter = printWriter;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if ("Issue".equals(entityName) && this.backupProject.containsIssue(this.getId(attributes))) {
            GenericEntity genericEntity = new GenericEntity(this.modelEntity, attributes);
            genericEntity.writeXmlText(this.printWriter, null);
            ++this.entityCount;
        }
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    String getId(Map attributes) {
        return (String)attributes.get("id");
    }
}

