/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.console;

import com.atlassian.jira.configurator.console.ConsoleProvider;
import java.io.IOException;

abstract class AbstractConsoleProvider
implements ConsoleProvider {
    AbstractConsoleProvider() {
    }

    protected IOException closed() {
        return new IOException("Console input stream has been closed");
    }

    protected void showPrompt(String prompt) {
        if (prompt != null) {
            this.print(prompt);
        }
        this.print("> ");
        this.flush();
    }

    @Override
    public String readLine() throws IOException {
        return this.readLine(null);
    }

    @Override
    public char readFirstChar(String prompt) throws IOException {
        String value = this.readLine(prompt);
        return value.length() > 0 ? value.charAt(0) : (char)'\n';
    }

    @Override
    public boolean readYesNo(String prompt, boolean defaultValue) throws IOException {
        prompt = prompt != null ? prompt + ' ' : "";
        prompt = prompt + (defaultValue ? " ([Y]/N)? " : " (Y/[N])? ");
        while (true) {
            switch (this.readFirstChar(prompt)) {
                case '\n': 
                case '\r': {
                    return defaultValue;
                }
                case '1': 
                case 'T': 
                case 'Y': 
                case 't': 
                case 'y': {
                    return true;
                }
                case '0': 
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    return false;
                }
            }
            this.println("*** Sorry, but I did not understand that.  Please enter Yes or No.");
        }
    }

    @Override
    public void printErrorMessage(String errorMessage) {
        this.println("*** " + errorMessage);
    }

    @Override
    public void printErrorMessage(Throwable ex) {
        String message = ex.getMessage();
        this.printErrorMessage(message != null ? message : ex.toString());
    }
}

