/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.customfield;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class DefaultCustomFieldService
implements CustomFieldService {
    private static final String CUSTOMFIELD_PREFIX = "customfield_";
    private static final String NONE_VALUE = "-1";
    private final GlobalPermissionManager permissionManager;
    private final CustomFieldManager customFieldManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;

    public DefaultCustomFieldService(GlobalPermissionManager permissionManager, CustomFieldManager customFieldManager, PermissionSchemeManager permissionSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager) {
        this.permissionManager = permissionManager;
        this.customFieldManager = customFieldManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
    }

    public void validateDelete(JiraServiceContext jiraServiceContext, Long customFieldId) {
        I18nHelper i18nBean = jiraServiceContext.getI18nBean();
        if (!this.permissionManager.hasPermission(0, jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"));
            return;
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.errors.customfields.invalid.custom.field"));
            return;
        }
        this.validateNotUsedInPermissionSchemes(jiraServiceContext, customFieldId, false);
    }

    public void validateUpdate(JiraServiceContext jiraServiceContext, Long customFieldId, String name, String description, String searcherKey) {
        if (customFieldId == null) {
            throw new IllegalArgumentException("customFieldId can not be null.");
        }
        I18nHelper i18nBean = jiraServiceContext.getI18nBean();
        if (!this.permissionManager.hasPermission(0, jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"));
            return;
        }
        CustomField originalCustomField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (originalCustomField == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.errors.customfields.invalid.custom.field"));
            return;
        }
        if (StringUtils.isEmpty((String)name)) {
            jiraServiceContext.getErrorCollection().addError("name", i18nBean.getText("admin.errors.customfields.no.name"));
            return;
        }
        if (StringUtils.isNotEmpty((String)searcherKey) && !NONE_VALUE.equals(searcherKey) && this.customFieldManager.getCustomFieldSearcher(searcherKey) == null) {
            jiraServiceContext.getErrorCollection().addError("searcher", i18nBean.getText("admin.errors.customfields.invalid.searcher"));
            return;
        }
        if (StringUtils.isEmpty((String)searcherKey) || NONE_VALUE.equals(searcherKey)) {
            this.validateNotUsedInPermissionSchemes(jiraServiceContext, customFieldId, true);
        }
    }

    void validateNotUsedInPermissionSchemes(JiraServiceContext jiraServiceContext, Long customFieldId, boolean forUpdate) {
        Set<GenericValue> usedIssueLevelSecuritySchemes;
        I18nHelper i18nBean = jiraServiceContext.getI18nBean();
        Set<GenericValue> usedPermissionSchemes = this.getUsedPermissionSchemes(customFieldId);
        if (!usedPermissionSchemes.isEmpty()) {
            String messageKey = forUpdate ? "admin.errors.customfields.used.in.permission.scheme.update" : "admin.errors.customfields.used.in.permission.scheme.delete";
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText(messageKey, GenericValueUtils.getCommaSeparatedList(usedPermissionSchemes, (String)"name")));
        }
        if (!(usedIssueLevelSecuritySchemes = this.getUsedIssueSecuritySchemes(customFieldId)).isEmpty()) {
            String messageKey = forUpdate ? "admin.errors.customfields.used.in.issuelevelschemes.update" : "admin.errors.customfields.used.in.issuelevelschemes.delete";
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText(messageKey, GenericValueUtils.getCommaSeparatedList(usedIssueLevelSecuritySchemes, (String)"name")));
        }
    }

    Set<GenericValue> getUsedPermissionSchemes(Long customFieldId) {
        HashSet<GenericValue> ret = new HashSet<GenericValue>();
        ret.addAll(this.permissionSchemeManager.getSchemesContainingEntity("userCF", CUSTOMFIELD_PREFIX + customFieldId));
        ret.addAll(this.permissionSchemeManager.getSchemesContainingEntity("groupCF", CUSTOMFIELD_PREFIX + customFieldId));
        return ret;
    }

    Set<GenericValue> getUsedIssueSecuritySchemes(Long customFieldId) {
        HashSet<GenericValue> ret = new HashSet<GenericValue>();
        ret.addAll(this.issueSecuritySchemeManager.getSchemesContainingEntity("userCF", CUSTOMFIELD_PREFIX + customFieldId));
        ret.addAll(this.issueSecuritySchemeManager.getSchemesContainingEntity("groupCF", CUSTOMFIELD_PREFIX + customFieldId));
        return ret;
    }
}

