/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.admin;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class NavigableFieldListValidator
implements Validator {
    private static final Logger log = Logger.getLogger(NavigableFieldListValidator.class);
    FieldManager fieldManager;

    public NavigableFieldListValidator(FieldManager fieldManager) {
        this.fieldManager = fieldManager;
    }

    public NavigableFieldListValidator() {
        this(ComponentManager.getComponent(FieldManager.class));
    }

    @Override
    public Validator.Result validate(String value) {
        String[] fields = value.split(",");
        ArrayList<String> badFields = new ArrayList<String>();
        for (String f : fields) {
            String field = f.trim();
            try {
                if (!"".equals(field) && this.fieldManager.getNavigableField(field) != null) continue;
                badFields.add(field);
                log.debug((Object)("Couldn't find requested navigable field '" + field + "'"));
            }
            catch (RuntimeException e) {
                badFields.add(field);
                log.debug((Object)("Couldn't find requested navigable field '" + field + "'"));
            }
        }
        if (badFields.isEmpty()) {
            return new Success(value);
        }
        String mesg = "The following fields are invalid: " + StringUtils.createCommaSeperatedString(badFields);
        return new Failure(mesg, TextUtils.htmlEncode((String)mesg));
    }
}

