/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.jira.config.component.AbstractComponentAdaptor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.util.concurrent.LazyReference;
import java.lang.reflect.Method;
import java.util.Collections;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class DateTimeFormatterComponentAdapter
extends AbstractComponentAdaptor<DateTimeFormatter> {
    private final LazyReference<DateTimeFormatter> proxyRef = new CglibProxyCreator();

    public DateTimeFormatterComponentAdapter() {
        super(DateTimeFormatter.class);
    }

    @Override
    public Class<?> getComponentImplementation() {
        return DateTimeFormatter.class;
    }

    @Override
    public Object getComponentInstance() throws PicoInitializationException, PicoIntrospectionException {
        return this.proxyRef.get();
    }

    @Override
    public void verify() throws UnsatisfiableDependenciesException {
        this.getFactoryFromContainer();
    }

    protected DateTimeFormatterFactory getFactoryFromContainer() {
        DateTimeFormatterFactory factory = (DateTimeFormatterFactory)this.getContainer().getComponentInstanceOfType(DateTimeFormatterFactory.class);
        if (factory == null) {
            throw new UnsatisfiableDependenciesException((ComponentAdapter)this, Collections.singleton(DateTimeFormatterFactory.class));
        }
        return factory;
    }

    static class DelegateToDateTimeFormatterInterceptor
    implements MethodInterceptor {
        private final DateTimeFormatterFactory factory;

        public DelegateToDateTimeFormatterInterceptor(DateTimeFormatterFactory factory) {
            this.factory = factory;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            DateTimeFormatter delegate = this.factory.formatter();
            return proxy.invoke((Object)delegate, args);
        }
    }

    class CglibProxyCreator
    extends LazyReference<DateTimeFormatter> {
        CglibProxyCreator() {
        }

        protected DateTimeFormatter create() throws Exception {
            DateTimeFormatterFactory factory = DateTimeFormatterComponentAdapter.this.getFactoryFromContainer();
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(DateTimeFormatter.class);
            enhancer.setCallback((Callback)new DelegateToDateTimeFormatterInterceptor(factory));
            return (DateTimeFormatter)enhancer.create();
        }
    }
}

