/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.issue;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpdateIssueFieldFunction
extends AbstractJiraFunctionProvider {
    private static final Logger log = Logger.getLogger(UpdateIssueFieldFunction.class);

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        FieldManager fieldManager = ComponentManager.getInstance().getFieldManager();
        String caller = this.getCallerName(transientVars, args);
        LinkedList changeItems = (LinkedList)transientVars.get("changeItems");
        if (changeItems == null) {
            changeItems = new LinkedList();
        }
        MutableIssue issue = (MutableIssue)transientVars.get("issue");
        String fieldName = (String)args.get("field.name");
        String fieldValue = (String)args.get("field.value");
        if (fieldValue != null && "null".equals(fieldValue)) {
            fieldValue = null;
        }
        if (TextUtils.stringSet((String)((String)args.get("field.type")))) {
            log.debug((Object)"There is no need to specify the field type in this version of JIRA. Remove the 'field.type' argument from the functions arguments.");
        }
        if ("status".equals(fieldName)) {
            log.warn((Object)"The use of UpdateIssueFieldFunction to update issue's status is deprecated. Please use UpdateIssueStatusFunction instead.");
            this.updateStatus(issue, fieldValue, changeItems);
            transientVars.put("changeItems", changeItems);
        } else if ("timespent".equals(fieldName)) {
            this.updateTimeSpent(issue, fieldValue, changeItems, transientVars);
        } else if ("timeoriginalestimate".equals(fieldName) || "timeestimate".equals(fieldName)) {
            try {
                long value = Long.parseLong(fieldValue);
                fieldValue = String.valueOf(value / 60L);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            String targetSubField = "timeoriginalestimate".equals(fieldName) ? "timetracking_originalestimate" : "timetracking_remainingestimate";
            Map map = MapBuilder.newBuilder().add((Object)"timetracking", (Object)this.toArr(fieldValue)).add((Object)"timetracking_targetsubfield", (Object)targetSubField).add((Object)"timetracking_originalestimate", (Object)this.toArr(fieldValue)).add((Object)"timetracking_remainingestimate", (Object)this.toArr(fieldValue)).toMap();
            this.processField(issue, "timetracking", map, caller, changeItems, transientVars);
        } else if (fieldManager.isOrderableField(fieldName)) {
            this.processField(issue, fieldName, MapBuilder.build((Object)fieldName, (Object)this.toArr(fieldValue)), caller, changeItems, transientVars);
        } else {
            throw new WorkflowException("Cannot update '" + fieldName + "' as it is not an orderable field.");
        }
    }

    private String[] toArr(String fieldValue) {
        return new String[]{fieldValue};
    }

    private void updateTimeSpent(MutableIssue issue, String fieldValue, List changeItems, Map transientVars) {
        try {
            Long oldTimeSpent = issue.getTimeSpent();
            Long newTimeSpent = new Long(fieldValue);
            if (!this.valuesEqual(oldTimeSpent, newTimeSpent)) {
                issue.setTimeSpent(newTimeSpent);
                String from = null;
                String fromString = null;
                String to = null;
                String toString = null;
                if (oldTimeSpent != null) {
                    from = fromString = oldTimeSpent.toString();
                }
                if (newTimeSpent != null) {
                    to = toString = newTimeSpent.toString();
                }
                changeItems.add(new ChangeItemBean("jira", "timespent", from, fromString, to, toString));
                transientVars.put("changeItems", changeItems);
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Cannot update field 'timespent' to '" + fieldValue + "' as the value must be numeric."));
        }
    }

    private void updateStatus(MutableIssue issue, String fieldValue, List changeItems) {
        GenericValue oldStatus = issue.getStatus();
        issue.setStatusId(fieldValue);
        GenericValue newStatus = issue.getStatus();
        if (!this.valuesEqual(oldStatus, newStatus)) {
            if (oldStatus != null) {
                changeItems.add(new ChangeItemBean("jira", "status", oldStatus.getString("id"), oldStatus.getString("name"), newStatus.getString("id"), newStatus.getString("name")));
            } else {
                changeItems.add(new ChangeItemBean("jira", "status", null, null, newStatus.getString("id"), newStatus.getString("name")));
            }
        }
    }

    private void processField(MutableIssue issue, String fieldName, Map inputParameters, String username, List changeItems, Map transientVars) throws WorkflowException {
        FieldManager fieldManager = this.getFieldManager();
        DefaultIssueChangeHolder changeHolder = new DefaultIssueChangeHolder();
        changeHolder.setChangeItems(changeItems);
        OrderableField field = fieldManager.getOrderableField(fieldName);
        HashMap fieldValuesHolder = new HashMap();
        field.populateFromParams(fieldValuesHolder, inputParameters);
        FieldLayoutItem fieldLayoutItem = null;
        try {
            fieldLayoutItem = issue.getGenericValue() != null ? ComponentAccessor.getFieldLayoutManager().getFieldLayout(issue.getGenericValue()).getFieldLayoutItem(field) : ComponentAccessor.getFieldLayoutManager().getFieldLayout(issue.getProject(), issue.getIssueType().getString("id")).getFieldLayoutItem(field);
        }
        catch (DataAccessException e) {
            log.error((Object)("GenerateChangeHistory is unable to resolve a field layout item for " + field.getName()), (Throwable)e);
        }
        field.updateIssue(fieldLayoutItem, issue, fieldValuesHolder);
        if (issue.getModifiedFields().containsKey(field.getId())) {
            field.updateValue(fieldLayoutItem, (Issue)issue, (ModifiedValue)issue.getModifiedFields().get(field.getId()), (IssueChangeHolder)changeHolder);
            issue.getModifiedFields().remove(field.getId());
        }
        transientVars.put("changeItems", changeHolder.getChangeItems());
    }

    FieldManager getFieldManager() {
        return ComponentManager.getInstance().getFieldManager();
    }

    public static FunctionDescriptor makeDescriptor(String fieldName, String fieldValue) {
        FunctionDescriptor descriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        descriptor.setType("class");
        descriptor.getArgs().put("class.name", UpdateIssueFieldFunction.class.getName());
        descriptor.getArgs().put("field.name", fieldName);
        descriptor.getArgs().put("field.value", fieldValue);
        return descriptor;
    }

    private boolean valuesEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

