/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.workflow.ImmutableWorkflowDescriptor;
import com.atlassian.jira.workflow.WorkflowDescriptorStore;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.XMLWorkflowFactory;
import java.util.Map;
import org.apache.log4j.Logger;

public class JiraWorkflowFactory
extends XMLWorkflowFactory {
    private static final Logger log = Logger.getLogger(JiraWorkflowFactory.class);
    private WorkflowDescriptorStore workflowDescriptorStore;

    public void initDone() throws FactoryException {
        super.initDone();
        this.workflowDescriptorStore = this.getWorkflowDescriptorStore();
    }

    public WorkflowDescriptor getWorkflow(String name) throws FactoryException {
        if (this.getWorkflowsFromParent().containsKey(name)) {
            return super.getWorkflow(name);
        }
        return this.workflowDescriptorStore.getWorkflow(name);
    }

    public String[] getWorkflowNames() {
        String[] osworkflowNames = super.getWorkflowNames();
        String[] workflowNames = this.workflowDescriptorStore.getWorkflowNames();
        String[] retNames = new String[osworkflowNames.length + workflowNames.length];
        System.arraycopy(osworkflowNames, 0, retNames, 0, osworkflowNames.length);
        System.arraycopy(workflowNames, 0, retNames, osworkflowNames.length, workflowNames.length);
        return retNames;
    }

    public boolean saveWorkflow(String name, WorkflowDescriptor descriptor, boolean replace) throws FactoryException {
        if (name == null) {
            return false;
        }
        if (this.getWorkflowsFromParent().get(name) != null) {
            return false;
        }
        return this.workflowDescriptorStore.saveWorkflow(name, descriptor, replace);
    }

    public boolean removeWorkflow(String name) throws FactoryException {
        return this.workflowDescriptorStore.removeWorkflow(name);
    }

    public boolean isModifiable(String name) {
        ImmutableWorkflowDescriptor workflow;
        if (name == null) {
            throw new IllegalArgumentException("The workflow name cannot be null");
        }
        if (this.getWorkflowsFromParent().containsKey(name)) {
            return false;
        }
        try {
            workflow = this.workflowDescriptorStore.getWorkflow(name);
        }
        catch (FactoryException e) {
            log.error((Object)"Unexpected error constructing workflow", (Throwable)e);
            return false;
        }
        if (workflow != null) {
            return true;
        }
        throw new IllegalArgumentException("The workflow: '" + name + "' does not exist.");
    }

    WorkflowDescriptorStore getWorkflowDescriptorStore() {
        return ComponentManager.getComponentInstanceOfType(WorkflowDescriptorStore.class);
    }

    Map getWorkflowsFromParent() {
        return this.workflows;
    }
}

