/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.sitemesh;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.component.webfragment.AdminTabsWebComponent;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AdminDecoratorHelper {
    public static final String ACTIVE_SECTION_KEY = "admin.active.section";
    public static final String ACTIVE_TAB_LINK_KEY = "admin.active.tab";
    private final WebInterfaceManager webInterfaceManager;
    private final ProjectService service;
    private final JiraAuthenticationContext authCtx;
    private final AdminTabsWebComponent tabsWebComponent;
    private String projectKey;
    private String currentTab;
    private String currentSection;
    private String selectedMenuSection;
    private ProjectService.GetProjectResult result;
    private List<Header> headers;
    private Pair<String, Integer> tabInfo;

    public AdminDecoratorHelper(WebInterfaceManager webInterfaceManager, ProjectService projectService, JiraAuthenticationContext authenticationContext, ComponentFactory componentFactory) {
        this.webInterfaceManager = webInterfaceManager;
        this.service = projectService;
        this.authCtx = authenticationContext;
        this.tabsWebComponent = componentFactory.createObject(AdminTabsWebComponent.class);
    }

    public AdminDecoratorHelper setProject(String projectKey) {
        this.clearCache();
        this.projectKey = StringUtils.stripToNull((String)projectKey);
        return this;
    }

    public AdminDecoratorHelper setCurrentTab(String currentTab) {
        this.clearCache();
        this.currentTab = StringUtils.stripToNull((String)currentTab);
        return this;
    }

    public AdminDecoratorHelper setCurrentSection(String currentSection) {
        this.clearCache();
        this.currentSection = StringUtils.stripToNull((String)currentSection);
        this.selectedMenuSection = StringUtils.contains((String)currentSection, (String)"/") ? currentSection.substring(0, currentSection.indexOf("/")) : currentSection;
        if (StringUtils.equals((String)"atl.jira.proj.config", (String)this.selectedMenuSection)) {
            this.selectedMenuSection = "admin_project_menu";
        }
        return this;
    }

    public String getSelectedMenuSection() {
        return this.selectedMenuSection;
    }

    public boolean hasKey() {
        return this.projectKey != null;
    }

    public List<Header> getHeaders() {
        String headerPanelSection;
        Map context;
        if (this.headers != null) {
            return this.headers;
        }
        Project project = this.getProject();
        if (project == null) {
            context = MapBuilder.build((Object)ACTIVE_SECTION_KEY, (Object)this.currentSection, (Object)ACTIVE_TAB_LINK_KEY, (Object)this.currentTab);
            headerPanelSection = "system.admin.decorator.header";
        } else {
            context = MapBuilder.build((Object)"project", (Object)project, (Object)ACTIVE_SECTION_KEY, (Object)this.currentSection, (Object)ACTIVE_TAB_LINK_KEY, (Object)this.currentTab);
            headerPanelSection = "atl.jira.proj.config.header";
        }
        List panels = this.webInterfaceManager.getDisplayableWebPanels(headerPanelSection, Collections.emptyMap());
        ArrayList<Header> headers = new ArrayList<Header>(panels.size());
        for (WebPanel panel : panels) {
            headers.add(new Header(panel, context));
        }
        this.headers = headers;
        return this.headers;
    }

    public int getNumberOfTabs() {
        return (Integer)this.getTabInfo().second();
    }

    public String getTabHtml() {
        return (String)this.getTabInfo().first();
    }

    private Pair<String, Integer> getTabInfo() {
        if (this.tabInfo != null) {
            return this.tabInfo;
        }
        this.tabInfo = this.tabsWebComponent.render(this.getProject(), this.currentSection, this.currentTab);
        return this.tabInfo;
    }

    private Project getProject() {
        ProjectService.GetProjectResult projectResult = this.getProjectResult();
        if (projectResult != null && projectResult.isValid()) {
            return projectResult.getProject();
        }
        return null;
    }

    private ProjectService.GetProjectResult getProjectResult() {
        if (this.result == null && this.hasKey()) {
            this.result = this.service.getProjectByKeyForAction(this.authCtx.getLoggedInUser(), this.projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        }
        return this.result;
    }

    private void clearCache() {
        this.result = null;
        this.headers = null;
        this.tabInfo = null;
    }

    public static class Header {
        private final Map<String, Object> contextMap;
        private final WebPanel panel;

        private Header(WebPanel panel, Map<String, Object> contextMap) {
            this.contextMap = contextMap;
            this.panel = panel;
        }

        public String getHtml() {
            return this.panel.getHtml(this.contextMap);
        }
    }
}

