/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.issuetypes.ExecutableAction;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanImpl;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class MultiBulkMoveBeanImpl
implements MultiBulkMoveBean {
    private static final Logger log = Logger.getLogger(MultiBulkMoveBeanImpl.class);
    private String operationName;
    private ListOrderedMap regularIssues;
    private List subTaskIssues;
    private ListOrderedMap issuesInContext;
    private ListOrderedMap bulkEditBeans;
    private Collection optionIds;
    private List regularOptions;
    private List subTaskOptions;
    private ExecutableAction executableAction;
    private String finalLocation;
    private int currentBulkEditBeanIndex = 0;
    private int subTasksDiscarded = 0;
    private final ConstantsManager constantsManager;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueManager issueManager;

    public MultiBulkMoveBeanImpl(String operationName, IssueManager issueManager) {
        this.operationName = operationName;
        this.issueManager = issueManager;
        this.constantsManager = ComponentAccessor.getConstantsManager();
        this.authenticationContext = ComponentAccessor.getJiraAuthenticationContext();
    }

    public void initOptionIds(Collection optionIds) {
        this.optionIds = optionIds;
        this.regularOptions = new ArrayList();
        this.subTaskOptions = new ArrayList();
        for (String optionId : optionIds) {
            IssueType issueType = this.constantsManager.getIssueTypeObject(optionId);
            if (!issueType.isSubTask()) {
                this.regularOptions.add(new IssueConstantOption((IssueConstant)issueType));
                continue;
            }
            this.subTaskOptions.add(new IssueConstantOption((IssueConstant)issueType));
        }
    }

    public void initFromIssues(List issues, BulkEditBean parentBulkEditBean) {
        this.issuesInContext = (ListOrderedMap)ListOrderedMap.decorate((Map)new MultiHashMap());
        this.regularIssues = new ListOrderedMap();
        this.subTaskIssues = new ArrayList();
        for (MutableIssue issue : issues) {
            if (!issue.isSubTask()) {
                this.regularIssues.put((Object)issue.getId(), (Object)issue);
                continue;
            }
            this.subTaskIssues.add(issue);
        }
        for (MutableIssue issue : issues) {
            if ("BulkMigrate".equals(this.operationName) && issue.isSubTask() && this.regularIssues.containsKey((Object)issue.getParentId())) {
                log.info((Object)("Sub issue: " + issue.getKey() + " : discarded since parent was also present in the bulk move"));
                ++this.subTasksDiscarded;
                continue;
            }
            this.issuesInContext.put((Object)new IssueContextImpl(issue.getProject(), issue.getIssueType()), (Object)issue);
        }
        this.bulkEditBeans = new ListOrderedMap();
        ArrayList keys = new ArrayList(this.issuesInContext.keySet());
        Collections.sort(keys);
        for (IssueContext context : keys) {
            Collection issuesForContext = (Collection)this.issuesInContext.get((Object)context);
            BulkEditBeanImpl bulkEditBean = new BulkEditBeanImpl(this.issueManager);
            bulkEditBean.initSelectedIssues(issuesForContext);
            bulkEditBean.setOperationName(this.operationName);
            bulkEditBean.setTargetProject(context.getProject());
            bulkEditBean.setTargetIssueTypeId(context.getIssueType() != null ? context.getIssueType().getString("id") : null);
            bulkEditBean.setParentBulkEditBean(parentBulkEditBean);
            this.bulkEditBeans.put((Object)context, (Object)bulkEditBean);
        }
    }

    public void remapBulkEditBeansByTargetContext() {
        ListOrderedMap bulkEditBeans = this.getBulkEditBeans();
        ListOrderedMap targetKeyedBulkEditBeans = new ListOrderedMap();
        Set entries = bulkEditBeans.entrySet();
        for (Map.Entry entry : entries) {
            BulkEditBean bulkEditBean = (BulkEditBean)entry.getValue();
            IssueContextImpl targetIssueContext = new IssueContextImpl(bulkEditBean.getTargetProjectGV(), bulkEditBean.getTargetIssueTypeGV());
            if (targetKeyedBulkEditBeans.containsKey((Object)targetIssueContext)) {
                BulkEditBean finalBulkEditBean = (BulkEditBean)targetKeyedBulkEditBeans.get((Object)targetIssueContext);
                finalBulkEditBean.addIssues((Collection)bulkEditBean.getSelectedIssues());
                continue;
            }
            targetKeyedBulkEditBeans.put((Object)targetIssueContext, (Object)bulkEditBean);
        }
        this.setBulkEditBeans(targetKeyedBulkEditBeans);
    }

    public void validate(ErrorCollection errors, BulkMoveOperation bulkMoveOperation, User user) {
        if (!this.regularIssues.isEmpty() && this.regularOptions.isEmpty()) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("admin.errors.bean.issues.affected", "" + this.regularIssues.size()));
        }
        if (!this.subTaskIssues.isEmpty() && this.subTaskOptions.isEmpty()) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("admin.errors.bean.subtasks.affected", "" + this.subTaskIssues.size()));
        }
        Set entries = this.bulkEditBeans.entrySet();
        for (Map.Entry entry : entries) {
            IssueContext issueContext = (IssueContext)entry.getKey();
            BulkEditBean bulkEditBean = (BulkEditBean)entry.getValue();
            if (bulkMoveOperation.canPerform(bulkEditBean, user)) continue;
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("admin.errors.bean.no.permission", "" + issueContext.getProject().getString("name"), "" + issueContext.getIssueType().getString("name")));
        }
    }

    public ListOrderedMap getIssuesInContext() {
        return this.issuesInContext;
    }

    public ListOrderedMap getBulkEditBeans() {
        return this.bulkEditBeans;
    }

    private void setBulkEditBeans(ListOrderedMap bulkEditBeans) {
        this.bulkEditBeans = bulkEditBeans;
    }

    public ExecutableAction getExecutableAction() {
        return this.executableAction;
    }

    public void setExecutableAction(ExecutableAction executableAction) {
        this.executableAction = executableAction;
    }

    public String getFinalLocation() {
        return this.finalLocation;
    }

    public void setFinalLocation(String finalLocation) {
        this.finalLocation = finalLocation;
    }

    public Collection getSelectedOptions() {
        return this.optionIds;
    }

    public List getRegularOptions() {
        return this.regularOptions;
    }

    public List getSubTaskOptions() {
        return this.subTaskOptions;
    }

    public int getSubTasksDiscarded() {
        return this.subTasksDiscarded;
    }

    public int getNumberOfStatusChangeRequired(BulkMoveOperation bulkMoveOperation) {
        int i = 0;
        for (BulkEditBean bulkEditBean : this.bulkEditBeans.values()) {
            if (bulkEditBean.getTargetPid() == null || bulkMoveOperation.isStatusValid(bulkEditBean)) continue;
            ++i;
        }
        return i;
    }

    public BulkEditBean getCurrentBulkEditBean() {
        if (!this.getBulkEditBeans().isEmpty()) {
            return (BulkEditBean)this.getBulkEditBeans().getValue(this.currentBulkEditBeanIndex);
        }
        return null;
    }

    public void progressToNextBulkEditBean() {
        if (!this.isLastBulkEditBean()) {
            ++this.currentBulkEditBeanIndex;
        } else {
            throw new IllegalArgumentException("Unable to progress to bulk edit bean with index greater than " + this.currentBulkEditBeanIndex + ". " + this.getBulkEditBeans().size() + " bulk edit beans available");
        }
    }

    public void progressToPreviousBulkEditBean() {
        if (this.currentBulkEditBeanIndex > 0) {
            --this.currentBulkEditBeanIndex;
        } else {
            throw new IllegalArgumentException("Unable to progress to bulk edit bean with index less than 0");
        }
    }

    public boolean isLastBulkEditBean() {
        return this.currentBulkEditBeanIndex == this.getBulkEditBeans().size() - 1;
    }

    public IssueContext getCurrentIssueContext() {
        if (!this.getBulkEditBeans().isEmpty()) {
            return (IssueContext)this.getBulkEditBeans().get(this.currentBulkEditBeanIndex);
        }
        return null;
    }

    public int getCurrentBulkEditBeanIndex() {
        return this.currentBulkEditBeanIndex;
    }

    public void setTargetProject(GenericValue targetProjectGV) {
        for (BulkEditBean bulkEditBean : this.getBulkEditBeans().values()) {
            bulkEditBean.setTargetProject(targetProjectGV);
        }
    }
}

