/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.seraph.service.rememberme.RememberMeService;
import webwork.action.ActionContext;

public class Logout
extends JiraWebActionSupport {
    private static final String LOGOUT = "logout";
    private static final String CONFIRM = "confirm";
    private static final String ALREADY_LOGGED_OUT = "alreadyloggedout";
    private final LoginManager loginManager;
    private final XsrfInvocationChecker xsrfInvocationChecker;
    private final JiraAuthenticationContext authenticationContext;
    private RememberMeService rememberMeService;

    public Logout(LoginManager loginManager, XsrfInvocationChecker xsrfInvocationChecker, RememberMeService rememberMeService, JiraAuthenticationContext authenticationContext) {
        this.loginManager = loginManager;
        this.xsrfInvocationChecker = xsrfInvocationChecker;
        this.authenticationContext = authenticationContext;
        this.rememberMeService = rememberMeService;
    }

    public String doExecute() {
        XsrfCheckResult result = this.xsrfInvocationChecker.checkWebRequestInvocation(ActionContext.getRequest());
        if (result.isValid()) {
            this.loginManager.logout(ActionContext.getRequest(), ActionContext.getResponse());
            return LOGOUT;
        }
        if (this.isUserAuthenticated()) {
            return CONFIRM;
        }
        return ALREADY_LOGGED_OUT;
    }

    public String doDefault() {
        XsrfCheckResult result = this.xsrfInvocationChecker.checkWebRequestInvocation(ActionContext.getRequest());
        if (result.isValid()) {
            String logOutPropertyValue = this.getApplicationProperties().getDefaultBackedString("jira.option.logoutconfirm");
            if ("always".equals(logOutPropertyValue)) {
                return CONFIRM;
            }
            if ("cookie".equals(logOutPropertyValue) && this.rememberMeService.getRememberMeCookieAuthenticatedUsername(ActionContext.getRequest(), ActionContext.getResponse()) != null) {
                return CONFIRM;
            }
            this.loginManager.logout(ActionContext.getRequest(), ActionContext.getResponse());
            return LOGOUT;
        }
        if (this.isUserAuthenticated()) {
            return CONFIRM;
        }
        return ALREADY_LOGGED_OUT;
    }

    private boolean isUserAuthenticated() {
        return this.authenticationContext.getUser() != null;
    }
}

