/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.operation.BulkEditAction;
import com.atlassian.jira.bulkedit.operation.BulkEditActionImpl;
import com.atlassian.jira.bulkedit.operation.BulkWorkflowTransitionOperation;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationDetailsAction;
import com.atlassian.jira.web.action.issue.bulkedit.WorkflowTransitionKey;
import com.atlassian.jira.web.action.issue.util.ScreenTabErrorHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.jelly.util.NestedRuntimeException;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;
import webwork.action.ActionContext;

public class BulkWorkflowTransition
extends AbstractBulkOperationDetailsAction {
    private static final String WORKFLOW_TRANSITION = "wftransition";
    public static final String RADIO_ERROR_MSG = "buik.edit.must.select.one.action.to.perform";
    private static final String FORCED_RESOLUTION = "forcedResolution";
    private String[] actions;
    private Map selectedActions;
    private String commentaction;
    private Map editActionsMap;
    private SortedSet tabsWithErrors;
    private int selectedTab;
    private final IssueWorkflowManager issueWorkflowManager;
    private final WorkflowManager workflowManager;
    private final IssueManager issueManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final JiraAuthenticationContext authenticationContext;
    private final BulkWorkflowTransitionOperation bulkWorkflowTransitionOperation;
    private BulkEditActionImpl commentBulkEditAction;
    private final PermissionManager permissionManager;

    public BulkWorkflowTransition(SearchService searchService, IssueWorkflowManager issueWorkflowManager, WorkflowManager workflowManager, IssueManager issueManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, JiraAuthenticationContext authenticationContext, FieldLayoutManager fieldLayoutManager, BulkWorkflowTransitionOperation bulkWorkflowTransitionOperation, PermissionManager permissionManager) {
        super(searchService);
        this.issueWorkflowManager = issueWorkflowManager;
        this.workflowManager = workflowManager;
        this.issueManager = issueManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.fieldManager = fieldManager;
        this.authenticationContext = authenticationContext;
        this.fieldLayoutManager = fieldLayoutManager;
        this.bulkWorkflowTransitionOperation = bulkWorkflowTransitionOperation;
        this.permissionManager = permissionManager;
    }

    @Override
    public String doDetails() throws Exception {
        BulkEditBean bulkEditBean = this.getBulkEditBean();
        if (bulkEditBean == null) {
            return this.redirectToStart();
        }
        bulkEditBean.setCurrentStep(3);
        this.getBulkEditBean().addAvailablePreviousStep(2);
        if (this.isCanDisableMailNotifications()) {
            bulkEditBean.setSendBulkNotification(false);
        } else {
            bulkEditBean.setSendBulkNotification(true);
        }
        this.setWorkflowTransitionMap();
        bulkEditBean.setActions(null);
        bulkEditBean.setSelectedWFTransitionKey(null);
        return "input";
    }

    @Override
    public String doDetailsValidation() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        if (!this.setWorkflowTransitionSelection()) {
            this.addErrorMessage(this.getText("bulkworkflowtransition.select.transition.error"));
            return "error";
        }
        this.initBeanWithSelection();
        return "success";
    }

    private void initBeanWithSelection() throws Exception {
        MultiMap workflowTransitionMap = this.getBulkEditBean().getWorkflowTransitionMap();
        ArrayList<MutableIssue> issues = new ArrayList<MutableIssue>();
        WorkflowTransitionKey workflowTransitionKey = this.getBulkEditBean().getSelectedWFTransitionKey();
        Collection issueKeys = (Collection)workflowTransitionMap.get((Object)workflowTransitionKey);
        ActionDescriptor actionDescriptor = this.getBulkWorkflowTransitionOperation().getActionDescriptor(workflowTransitionKey);
        for (String issueKey : issueKeys) {
            MutableIssue issue = this.issueManager.getIssueObject(issueKey);
            issues.add(issue);
        }
        this.getBulkEditBean().initSelectedIssues(issues);
        FieldScreenRenderer fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issues, actionDescriptor);
        this.getBulkEditBean().setFieldScreenRenderer(fieldScreenRenderer);
    }

    public String doEditValidation() {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.validateInput();
        if (this.invalidInput()) {
            return "error";
        }
        this.updateBean();
        return "success";
    }

    @Override
    public String doPerform() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.validationPerform();
        if (this.invalidInput()) {
            return "error";
        }
        this.getBulkWorkflowTransitionOperation().perform(this.getBulkEditBean(), this.getLoggedInUser());
        return this.finishWizard();
    }

    private void validationPerform() {
        if (!this.permissionManager.hasPermission(33, this.getLoggedInUser())) {
            this.addErrorMessage(this.getText("bulk.change.no.permission", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            return;
        }
        if (!this.getBulkWorkflowTransitionOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser())) {
            this.addErrorMessage(this.getText("bulk.workflowtransition.cannotperform", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            return;
        }
    }

    public Collection getEditActions(String fieldScreenTabName) {
        if (this.editActionsMap == null) {
            this.editActionsMap = new HashMap();
        } else if (this.editActionsMap.containsKey(fieldScreenTabName)) {
            return (Collection)this.editActionsMap.get(fieldScreenTabName);
        }
        ArrayList<BulkEditAction> editActions = new ArrayList<BulkEditAction>();
        List fieldScreenRenderTabs = this.getBulkEditBean().getFieldScreenRenderer().getFieldScreenRenderTabs();
        for (FieldScreenRenderTab screenRenderTab : fieldScreenRenderTabs) {
            if (!screenRenderTab.getName().equals(fieldScreenTabName)) continue;
            List bulkFieldScreenRenderLayoutItems = screenRenderTab.getFieldScreenRenderLayoutItems();
            for (FieldScreenRenderLayoutItem bulkFieldScreenRenderLayoutItem : bulkFieldScreenRenderLayoutItems) {
                String actionName = bulkFieldScreenRenderLayoutItem.getFieldScreenLayoutItem().getFieldId();
                editActions.add(this.buildBulkEditAction(actionName));
            }
        }
        this.editActionsMap.put(fieldScreenTabName, editActions);
        return editActions;
    }

    public BulkEditAction getCommentBulkEditAction() {
        if (this.commentBulkEditAction == null) {
            this.commentBulkEditAction = new BulkEditActionImpl("comment", this.fieldManager, this.authenticationContext);
        }
        return this.commentBulkEditAction;
    }

    public String getCommentHtml() {
        OrderableField commentField = this.fieldManager.getOrderableField("comment");
        boolean required = false;
        boolean hidden = false;
        String rendererType = null;
        for (FieldLayout fieldLayout : this.getBulkEditBean().getFieldLayouts()) {
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(commentField);
            if (fieldLayoutItem.isHidden()) {
                hidden = true;
            }
            if (fieldLayoutItem.isRequired()) {
                required = true;
            }
            rendererType = fieldLayoutItem.getRendererType();
            if (!hidden || !required) continue;
            break;
        }
        FieldLayoutItemImpl fieldLayoutItem = new FieldLayoutItemImpl.Builder().setOrderableField(commentField).setFieldDescription(null).setHidden(hidden).setRequired(required).setRendererType(rendererType).build();
        return commentField.getEditHtml((FieldLayoutItem)fieldLayoutItem, (OperationContext)this.getBulkEditBean(), (Action)this, null, EasyMap.build((Object)"noHeader", (Object)Boolean.TRUE));
    }

    public Map getAllEditActions() {
        List fieldScreenRenderTabs = this.getBulkEditBean().getFieldScreenRenderer().getFieldScreenRenderTabs();
        HashMap<String, BulkEditAction> editActions = new HashMap<String, BulkEditAction>();
        for (FieldScreenRenderTab screenRenderTab : fieldScreenRenderTabs) {
            List bulkFieldScreenRenderLayoutItems = screenRenderTab.getFieldScreenRenderLayoutItems();
            for (FieldScreenRenderLayoutItem bulkFieldScreenRenderLayoutItem : bulkFieldScreenRenderLayoutItems) {
                String actionName = bulkFieldScreenRenderLayoutItem.getFieldScreenLayoutItem().getFieldId();
                editActions.put(actionName, this.buildBulkEditAction(actionName));
            }
        }
        return editActions;
    }

    private BulkEditAction buildBulkEditAction(String fieldId) {
        return new BulkEditActionImpl(fieldId, this.fieldManager, this.authenticationContext);
    }

    private void validateInput() {
        this.selectedActions = new ListOrderedMap();
        if (this.getActions() != null && this.getActions().length != 0) {
            Map allEditActions = this.getAllEditActions();
            for (int i = 0; i < this.getActions().length; ++i) {
                String fieldId = this.getActions()[i];
                BulkEditAction bulkEditAction = (BulkEditAction)allEditActions.get(fieldId);
                this.selectedActions.put(bulkEditAction.getField().getId(), bulkEditAction);
                bulkEditAction.getField().populateFromParams(this.getBulkEditBean().getFieldValuesHolder(), ActionContext.getParameters());
                for (Issue issue : this.getBulkEditBean().getSelectedIssues()) {
                    bulkEditAction.getField().validateParams((OperationContext)this.getBulkEditBean(), (ErrorCollection)this, (I18nHelper)this, issue, this.buildFieldScreenRenderLayoutItem(bulkEditAction.getField(), issue.getGenericValue()));
                }
            }
        }
        if (TextUtils.stringSet((String)this.getCommentaction())) {
            BulkEditAction bulkEditAction = this.getCommentBulkEditAction();
            if (bulkEditAction.isAvailable(this.getBulkEditBean())) {
                this.selectedActions.put(bulkEditAction.getField().getId(), bulkEditAction);
                bulkEditAction.getField().populateFromParams(this.getBulkEditBean().getFieldValuesHolder(), ActionContext.getParameters());
                for (Issue issue : this.getBulkEditBean().getSelectedIssues()) {
                    bulkEditAction.getField().validateParams((OperationContext)this.getBulkEditBean(), (ErrorCollection)this, (I18nHelper)this, issue, this.buildFieldScreenRenderLayoutItem(bulkEditAction.getField(), issue.getGenericValue()));
                }
            } else {
                this.addErrorMessage(this.getText("bulkworkflowtransition.comment.cannotspecify"));
            }
        }
    }

    public boolean isHasAvailableActions() throws Exception {
        return this.getBulkWorkflowTransitionOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser());
    }

    private void updateBean() {
        if (this.selectedActions != null && !this.selectedActions.isEmpty()) {
            this.getBulkEditBean().setActions(this.selectedActions);
            try {
                for (BulkEditAction bulkEditAction : this.getBulkEditBean().getActions().values()) {
                    OrderableField field = bulkEditAction.getField();
                    Object value = field.getValueFromParams(this.getBulkEditBean().getFieldValuesHolder());
                    this.getBulkEditBean().getFieldValues().put(field.getId(), value);
                }
            }
            catch (FieldValidationException e) {
                this.log.error((Object)"Error getting field value.", (Throwable)e);
                throw new NestedRuntimeException("Error getting field value.", (Throwable)e);
            }
        }
        this.getBulkEditBean().clearAvailablePreviousSteps();
        this.getBulkEditBean().addAvailablePreviousStep(1);
        this.getBulkEditBean().addAvailablePreviousStep(2);
        this.getBulkEditBean().addAvailablePreviousStep(3);
        this.getBulkEditBean().setCurrentStep(4);
    }

    public String getOperationDetailsActionName() {
        return this.getBulkWorkflowTransitionOperation().getOperationName() + "Details.jspa";
    }

    public boolean isChecked(String value) {
        if (this.getActions() == null || this.getActions().length == 0) {
            if (this.getBulkEditBean().getActions() != null) {
                return this.getBulkEditBean().getActions().containsKey(value);
            }
            return false;
        }
        if ("comment".equals(value)) {
            return TextUtils.stringSet((String)this.getCommentaction());
        }
        for (int i = 0; i < this.getActions().length; ++i) {
            String action = this.getActions()[i];
            if (!action.equals(value)) continue;
            return true;
        }
        return false;
    }

    private void setWorkflowTransitionMap() throws WorkflowException {
        if (this.getBulkEditBean().getWorkflowTransitionMap() == null || this.getBulkEditBean().getWorkflowTransitionMap().isEmpty()) {
            List selectedIssues = this.getBulkEditBean().getSelectedIssues();
            MultiHashMap workflowTransitionMap = new MultiHashMap();
            for (Issue issue : selectedIssues) {
                JiraWorkflow workflow = this.workflowManager.getWorkflow(issue.getGenericValue());
                String workflowName = workflow.getName();
                Collection availableActions = this.issueWorkflowManager.getAvailableActions(issue);
                for (ActionDescriptor actionDescriptor : availableActions) {
                    WorkflowTransitionKey workflowTransitionKey;
                    String actionDescriptorId = String.valueOf(actionDescriptor.getId());
                    int resultStep = actionDescriptor.getUnconditionalResult().getStep();
                    if (resultStep == -1) {
                        workflowTransitionKey = new WorkflowTransitionKey(workflowName, actionDescriptorId, issue.getStatusObject().getId());
                    } else {
                        Status resultStatus = workflow.getLinkedStatusObject(workflow.getDescriptor().getStep(resultStep));
                        workflowTransitionKey = new WorkflowTransitionKey(workflowName, actionDescriptorId, resultStatus.getId());
                    }
                    workflowTransitionMap.put((Object)workflowTransitionKey, (Object)issue.getKey());
                }
            }
            this.getBulkEditBean().setWorkflowTransitionMap((MultiMap)workflowTransitionMap);
        }
    }

    private boolean setWorkflowTransitionSelection() {
        this.getBulkEditBean().resetWorkflowTransitionSelection();
        boolean selectionMade = false;
        Map params = ActionContext.getParameters();
        if (params != null && !params.isEmpty()) {
            Set keys = params.keySet();
            for (String key : keys) {
                if (!key.equals(WORKFLOW_TRANSITION)) continue;
                String[] actionId = (String[])params.get(key);
                String code = actionId[0];
                WorkflowTransitionKey wtkey = this.decodeWorkflowTransitionKey(code);
                this.getBulkEditBean().setSelectedWFTransitionKey(wtkey);
                selectionMade = true;
            }
        }
        return selectionMade;
    }

    public WorkflowTransitionKey decodeWorkflowTransitionKey(String encoded) {
        int i = encoded.lastIndexOf(95);
        String destinationStatus = encoded.substring(i + 1, encoded.length());
        String rest = encoded.substring(0, i);
        int secondDividerIndex = rest.lastIndexOf(95);
        String actionId = rest.substring(secondDividerIndex + 1, rest.length());
        String workflowName = rest.substring(0, secondDividerIndex);
        return new WorkflowTransitionKey(workflowName, actionId, destinationStatus);
    }

    public String encodeWorkflowTransitionKey(WorkflowTransitionKey workflowTransitionKey) {
        return workflowTransitionKey.getWorkflowName() + "_" + workflowTransitionKey.getActionDescriptorId() + "_" + workflowTransitionKey.getDestinationStatus();
    }

    public GenericValue getOriginStatus(WorkflowTransitionKey workflowTransitionKey) {
        Collection issueKeys = (Collection)this.getBulkEditBean().getWorkflowTransitionMap().get((Object)workflowTransitionKey);
        String issueKey = (String)issueKeys.iterator().next();
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        return issue.getStatus();
    }

    public GenericValue getDestinationStatus(WorkflowTransitionKey workflowTransitionKey) {
        ActionDescriptor actionDescriptor = this.getBulkWorkflowTransitionOperation().getActionDescriptor(workflowTransitionKey);
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowTransitionKey.getWorkflowName());
        int newStepId = actionDescriptor.getUnconditionalResult().getStep();
        if (newStepId == -1) {
            return this.getOriginStatus(workflowTransitionKey);
        }
        StepDescriptor step = workflow.getDescriptor().getStep(newStepId);
        return workflow.getLinkedStatus(step);
    }

    public List getShortListTransitionIssueKeys(Collection issueKeys) {
        int count = 0;
        ArrayList<String> shortList = new ArrayList<String>();
        for (String issueKey : issueKeys) {
            shortList.add(issueKey);
            if (++count < 5) continue;
            break;
        }
        return shortList;
    }

    public String[] getActions() {
        Map params = ActionContext.getParameters();
        if (params != null && params.containsKey(FORCED_RESOLUTION)) {
            String[] strings = (String[])params.get(FORCED_RESOLUTION);
            if (this.actions == null) {
                this.actions = new String[1];
                this.actions[0] = strings[0];
                return this.actions;
            }
            String[] newActions = new String[this.actions.length + 1];
            for (int i = 0; i < this.actions.length; ++i) {
                newActions[i] = this.actions[i];
            }
            newActions[this.actions.length] = strings[0];
            return newActions;
        }
        return this.actions;
    }

    public void setActions(String[] actions) {
        this.actions = actions;
    }

    public boolean isForceResolution(Field field) {
        return "resolution".equals(field.getId());
    }

    public String getCommentaction() {
        return this.commentaction;
    }

    public void setCommentaction(String commentaction) {
        this.commentaction = commentaction;
    }

    public String getFieldViewHtml(OrderableField orderableField) {
        FieldLayoutItem layoutItem = null;
        if (!this.getBulkEditBean().getFieldLayouts().isEmpty()) {
            layoutItem = ((FieldLayout)this.getBulkEditBean().getFieldLayouts().iterator().next()).getFieldLayoutItem(orderableField);
        }
        Map displayParams = MapBuilder.newBuilder((Object)"readonly", (Object)Boolean.TRUE).add((Object)"nolink", (Object)Boolean.TRUE).add((Object)"bulkoperation", (Object)this.getBulkEditBean().getOperationName()).add((Object)"prefix", (Object)"new_").toMutableMap();
        return orderableField.getViewHtml(layoutItem, (Action)this, (Issue)this.getBulkEditBean().getSelectedIssues().iterator().next(), this.getBulkEditBean().getFieldValues().get(orderableField.getId()), displayParams);
    }

    public String getFieldHtml(OrderableField orderableField) throws Exception {
        return orderableField.getBulkEditHtml((OperationContext)this.getBulkEditBean(), (Action)this, this.getBulkEditBean(), EasyMap.build((Object)"noHeader", (Object)Boolean.TRUE));
    }

    public Collection getFieldScreenRenderTabs() {
        return this.getBulkEditBean().getFieldScreenRenderer().getFieldScreenRenderTabs();
    }

    protected FieldScreenRenderLayoutItem buildFieldScreenRenderLayoutItem(OrderableField field, GenericValue issue) {
        return new FieldScreenRenderLayoutItemImpl(null, this.fieldLayoutManager.getFieldLayout(issue).getFieldLayoutItem(field));
    }

    public BulkWorkflowTransitionOperation getBulkWorkflowTransitionOperation() {
        return this.bulkWorkflowTransitionOperation;
    }

    private void initTabsWithErrors() {
        this.tabsWithErrors = new TreeSet();
        this.selectedTab = new ScreenTabErrorHelper().initialiseTabsWithErrors(this.tabsWithErrors, this.getErrors(), this.getBulkEditBean().getFieldScreenRenderer(), ActionContext.getParameters());
    }

    public Collection getTabsWithErrors() {
        if (this.tabsWithErrors == null) {
            this.initTabsWithErrors();
        }
        return this.tabsWithErrors;
    }

    public int getSelectedTab() {
        if (this.tabsWithErrors == null) {
            this.initTabsWithErrors();
        }
        return this.selectedTab;
    }

    public String removeSpaces(String string) {
        return StringUtils.deleteWhitespace((String)string);
    }

    protected String redirectToStart() {
        return super.redirectToStart("bulkworkflowtransition.session.timeout.message");
    }
}

