/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationAction;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

public class BulkChooseOperation
extends AbstractBulkOperationAction {
    private Collection bulkOperations;
    private String operation;
    final BulkOperationManager bulkOperationManager;

    public BulkChooseOperation(SearchService searchService, BulkOperationManager bulkOperationManager) {
        super(searchService);
        this.bulkOperationManager = bulkOperationManager;
        this.bulkOperations = bulkOperationManager.getBulkOperations();
    }

    public String doDefault() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart("bulk.chooseoperation.session.timeout.message");
        }
        this.getBulkEditBean().addAvailablePreviousStep(1);
        this.getBulkEditBean().setCurrentStep(2);
        return this.getResult();
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.getOperation())) {
            this.addErrorMessage(this.getText("bulk.chooseoperation.chooseoperation.error"));
        } else {
            if (!this.bulkOperationManager.isValidOperation(this.getOperation())) {
                this.addErrorMessage(this.getText("bulk.chosseoperation.invalid.operation"));
            }
            if ("BulkMove".equals(this.getOperation()) && this.getBulkEditBean() != null && this.getBulkEditBean().isOnlyContainsSubTasks()) {
                this.addErrorMessage(this.getText("admin.errors.issuebulkedit.cannot.move.sub.tasks"));
            }
        }
        super.doValidation();
    }

    protected String doExecute() throws Exception {
        BulkEditBean beb = this.getBulkEditBean();
        String operationName = this.bulkOperationManager.getOperation(this.getOperation()).getOperationName();
        if (beb != null) {
            if (operationName != null) {
                if (operationName.equals("BulkMove")) {
                    beb.setOperationName("BulkMove");
                } else if (operationName.equals("BulkWorkflowTransition")) {
                    beb.setOperationName("BulkWorkflowTransition");
                } else if (operationName.equals("BulkEdit")) {
                    beb.setOperationName("BulkEdit");
                } else if (operationName.equals("BulkDelete")) {
                    beb.setOperationName("BulkDelete");
                }
            }
        } else {
            return this.redirectToStart("bulk.chooseoperation.session.timeout.message");
        }
        return this.getRedirect(operationName + "Details.jspa");
    }

    public Collection getBulkOperations() {
        return this.bulkOperations;
    }

    public boolean isCanPerform(BulkOperation bulkOperation) throws Exception {
        return bulkOperation.canPerform(this.getBulkEditBean(), this.getLoggedInUser());
    }

    public boolean isHasAvailableOperations() throws Exception {
        for (BulkOperation bulkOperation : this.bulkOperations) {
            if (!this.isCanPerform(bulkOperation)) continue;
            return true;
        }
        return false;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}

