/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.xml.sax.SAXException;

@WebSudoRequired
public class ImportWorkflow
extends JiraWebActionSupport {
    private String name;
    private String description;
    private String filePath;
    private String workflowXML;
    private final WorkflowManager workflowManager;

    public ImportWorkflow(WorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.name)) {
            this.addError("name", this.getText("admin.errors.workflows.specify.workflow.name"));
        } else {
            try {
                if (this.workflowManager.workflowExists(this.name)) {
                    this.addError("name", this.getText("admin.errors.a.workflow.with.this.name.already.exists"));
                }
            }
            catch (WorkflowException e) {
                this.log.error((Object)"Error occurred while reading workflow information.", (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.workflows.error.reading.information"));
            }
        }
        if (TextUtils.stringSet((String)this.filePath) && TextUtils.stringSet((String)this.workflowXML)) {
            this.addError("filePath", this.getText("admin.errors.workflows.specify.path.or.xml"));
        } else if (!TextUtils.stringSet((String)this.filePath) && !TextUtils.stringSet((String)this.workflowXML)) {
            this.addErrorMessage(this.getText("admin.errors.workflows.must.specify.path.or.xml"));
        } else if (TextUtils.stringSet((String)this.filePath)) {
            File workflowFile = new File(this.filePath);
            if (!workflowFile.exists()) {
                this.addError("filePath", this.getText("admin.errors.workflows.file.does.not.exist"));
            } else if (!workflowFile.canRead()) {
                this.addError("filePath", this.getText("admin.errors.workflows.file.not.readable"));
            } else if (!workflowFile.isFile()) {
                this.addError("filePath", this.getText("admin.errors.workflows.file.not.regular"));
            }
        }
        super.doValidation();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            WorkflowDescriptor workflowDescriptor = WorkflowLoader.load((InputStream)this.getWorkflowXMLInputStream(), (boolean)true);
            ConfigurableJiraWorkflow newWorkflow = new ConfigurableJiraWorkflow(this.name, workflowDescriptor, this.workflowManager);
            newWorkflow.setDescription(this.description);
            this.workflowManager.createWorkflow(this.getLoggedInUser(), (JiraWorkflow)newWorkflow);
            return this.getRedirect("ListWorkflows.jspa");
        }
        catch (FileNotFoundException e) {
            String message = "Error loading workflow from file.";
            this.addErrorMessage(message + " Please see log for more details.");
            this.log.error((Object)message, (Throwable)e);
            return "error";
        }
        catch (InvalidWorkflowDescriptorException e) {
            String message = "Invalid workflow XML: " + e.getMessage();
            this.addErrorMessage(message + ". Please see log for more details.");
            this.log.error((Object)message, (Throwable)e);
            return "error";
        }
        catch (IOException e) {
            String message = "Error loading workflow.";
            this.addErrorMessage(this.getText("admin.errors.workflows.error.loading.workflow") + " Please see log for more details.");
            this.log.error((Object)message, (Throwable)e);
            return "error";
        }
        catch (SAXException e) {
            String message = "Error parsing workflow XML: " + e.getMessage();
            this.addErrorMessage(this.getText("admin.errors.workflows.error.parsing.xml", e.getMessage()) + ". Please see log for more details.");
            this.log.error((Object)message, (Throwable)e);
            return "error";
        }
        catch (WorkflowException e) {
            String message = "Error saving workflow: " + e.getMessage();
            this.addErrorMessage(this.getText("admin.errors.workflows.error.saving.workflow", e.getMessage()) + " Please see log for more details.");
            this.log.error((Object)message, (Throwable)e);
            return "error";
        }
    }

    private InputStream getWorkflowXMLInputStream() throws FileNotFoundException, UnsupportedEncodingException {
        if (TextUtils.stringSet((String)this.filePath)) {
            return new FileInputStream(this.filePath);
        }
        if (TextUtils.stringSet((String)this.workflowXML)) {
            return new ByteArrayInputStream(this.workflowXML.getBytes());
        }
        throw new IllegalStateException("Neither file path nor XML are given.");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getWorkflowXML() {
        return this.workflowXML;
    }

    public void setWorkflowXML(String workflowXML) {
        this.workflowXML = workflowXML;
    }
}

