/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.admin.user.ViewUser;
import java.util.ArrayList;
import java.util.Collection;

public class DeleteUser
extends ViewUser {
    boolean confirm;
    long assignedIssues = -1L;
    long reportedIssues = -1L;
    private ArrayList<Project> projectsUserLeads;
    private ArrayList<ProjectComponent> componentsUserLeads;
    private final SearchRequestService searchRequestService;
    private final UserUtil userUtil;
    private final PortalPageService portalPageService;
    private UserService.DeleteUserValidationResult validationResult;
    private UserService userService;

    public DeleteUser(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, UserManager userManager) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
        this.searchRequestService = ComponentManager.getComponentInstanceOfType(SearchRequestService.class);
        this.portalPageService = ComponentManager.getInstance().getPortalPageService();
        this.userService = ComponentManager.getComponentInstanceOfType(UserService.class);
        this.userUtil = ComponentAccessor.getUserUtil();
    }

    public DeleteUser(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, SearchRequestService searchRequestService, UserService userService, UserUtil userUtil, PortalPageService portalPageService, UserPropertyManager userPropertyManager, UserManager userManager) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
        this.searchRequestService = searchRequestService;
        this.userService = userService;
        this.userUtil = userUtil;
        this.portalPageService = portalPageService;
    }

    @Override
    protected void doValidation() {
        this.validationResult = this.userService.validateDeleteUser(this.getLoggedInUser(), this.getUser().getName());
        if (!this.validationResult.isValid()) {
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
        super.doValidation();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            if (this.confirm) {
                this.userService.removeUser(this.getLoggedInUser(), this.validationResult);
            }
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.users.exception.trying.to.remove", e));
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect("UserBrowser.jspa");
    }

    public boolean isDeleteable() {
        try {
            return this.getNumberOfReportedIssues() == 0L && this.getNumberOfAssignedIssues() == 0L && this.getNumberOfProjectsUserLeads() == 0L && !this.isNonSysAdminAttemptingToDeleteSysAdmin();
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public long getNumberOfAssignedIssues() throws Exception {
        if (this.assignedIssues == -1L) {
            this.assignedIssues = this.userUtil.getNumberOfAssignedIssuesIgnoreSecurity(this.getLoggedInUser(), this.getUser());
        }
        return this.assignedIssues;
    }

    public long getNumberOfReportedIssues() throws Exception {
        if (this.reportedIssues == -1L) {
            this.reportedIssues = this.userUtil.getNumberOfReportedIssuesIgnoreSecurity(this.getLoggedInUser(), this.getUser());
        }
        return this.reportedIssues;
    }

    public boolean isNonSysAdminAttemptingToDeleteSysAdmin() {
        return this.userUtil.isNonSysAdminAttemptingToDeleteSysAdmin(this.getLoggedInUser(), this.getUser());
    }

    public long getNumberOfFilters() {
        Collection requests = this.searchRequestService.getNonPrivateFilters(this.getUser());
        return requests.size();
    }

    public long getNumberOfOtherFavouritedFilters() {
        Collection requests = this.searchRequestService.getFiltersFavouritedByOthers(this.getUser());
        return requests.size();
    }

    public long getNumberOfNonPrivatePortalPages() {
        Collection requests = this.portalPageService.getNonPrivatePortalPages(this.getUser());
        return requests.size();
    }

    public long getNumberOfOtherFavouritedPortalPages() {
        Collection requests = this.portalPageService.getPortalPagesFavouritedByOthers(this.getUser());
        return requests.size();
    }

    public Collection<Project> getProjectsUserLeads() {
        return this.getProjectsUserLeads(-1);
    }

    public Collection<Project> getProjectsUserLeads(int limit) {
        if (this.projectsUserLeads == null) {
            this.projectsUserLeads = new ArrayList(this.userUtil.getProjectsLeadBy(this.getUser()));
        }
        if (limit == -1 || limit > this.projectsUserLeads.size()) {
            return this.projectsUserLeads;
        }
        return this.projectsUserLeads.subList(0, limit);
    }

    public long getNumberOfProjectsUserLeads() {
        return this.getProjectsUserLeads().size();
    }

    public Collection<ProjectComponent> getComponentsUserLeads() {
        if (this.componentsUserLeads == null) {
            this.componentsUserLeads = new ArrayList(this.userUtil.getComponentsUserLeads(this.getUser()));
        }
        return this.componentsUserLeads;
    }

    public Collection<ProjectComponent> getComponentsUserLeads(int limit) {
        ArrayList<ProjectComponent> componentsUserLeads = new ArrayList<ProjectComponent>(this.getComponentsUserLeads());
        if (limit > componentsUserLeads.size()) {
            return componentsUserLeads;
        }
        return componentsUserLeads.subList(0, limit);
    }

    public String getProjectKey(ProjectComponent component) {
        Project project = this.getProjectManager().getProjectObj(component.getProjectId());
        return project.getKey();
    }

    public long getNumberOfComponentsUserLeads() {
        return this.getComponentsUserLeads().size();
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }
}

