/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.web.action.admin.constants.AbstractEditConstant;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class EditPriority
extends AbstractEditConstant {
    private boolean preview = false;
    private String statusColor;

    @Override
    public String doDefault() throws Exception {
        this.setStatusColor(this.getConstant().getString("statusColor"));
        return super.doDefault();
    }

    @Override
    protected void doValidation() {
        if (!this.isPreview()) {
            if (!TextUtils.stringSet((String)this.getIconurl())) {
                this.addError("iconurl", this.getText("admin.errors.must.specify.url.for.icon"));
            }
            if (!TextUtils.stringSet((String)this.getStatusColor())) {
                this.addError("statusColor", this.getText("admin.errors.must.specify.color"));
            }
            super.doValidation();
        }
    }

    @Override
    protected String doExecute() throws Exception {
        if (this.isPreview()) {
            return "input";
        }
        this.getConstant().set("statusColor", (Object)this.getStatusColor());
        return super.doExecute();
    }

    @Override
    protected String getConstantEntityName() {
        return "Priority";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.priority.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "priority";
    }

    @Override
    protected GenericValue getConstant(String id) {
        Priority priorityObject = this.getConstantsManager().getPriorityObject(id);
        return priorityObject != null ? priorityObject.getGenericValue() : null;
    }

    @Override
    protected String getRedirectPage() {
        return "ViewPriorities.jspa";
    }

    @Override
    protected Collection<GenericValue> getConstants() {
        return this.getConstantsManager().getPriorities();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshPriorities();
    }

    public String getStatusColor() {
        return this.statusColor;
    }

    public void setStatusColor(String statusColor) {
        this.statusColor = statusColor;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }
}

