/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.permission;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.permission.ProjectPermissionSchemeHelper;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.web.action.admin.permission.SchemeAwarePermissionAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class EditPermissions
extends SchemeAwarePermissionAction {
    private final SchemePermissions schemePermissions;
    private final ProjectPermissionSchemeHelper helper;
    private String usersGroupsRolesHeaderText;
    private List<Project> projects;

    public EditPermissions(SchemePermissions schemePermissions, ProjectPermissionSchemeHelper helper) {
        this.schemePermissions = schemePermissions;
        this.helper = helper;
    }

    public Map getSchemePermissions() {
        return this.schemePermissions.getSchemePermissions();
    }

    public Map getProjectPermissions() {
        return this.schemePermissions.getProjectPermissions();
    }

    public Map getIssuePermissions() {
        return this.schemePermissions.getIssuePermissions();
    }

    public Map getVotersAndWatchersPermissions() {
        return this.schemePermissions.getVotersAndWatchersPermissions();
    }

    public Map getTimeTrackingPermissions() {
        return this.schemePermissions.getTimeTrackingPermissions();
    }

    public Map getCommentsPermissions() {
        return this.schemePermissions.getCommentsPermissions();
    }

    public Map getAttachmentsPermissions() {
        return this.schemePermissions.getAttachmentsPermissions();
    }

    public String getI18nUsersGroupsRolesHeader() {
        if (this.usersGroupsRolesHeaderText == null) {
            this.usersGroupsRolesHeaderText = this.getText("admin.common.words.users.groups.roles");
        }
        return this.usersGroupsRolesHeaderText;
    }

    public List getPermissions(Long permission) throws GenericEntityException {
        return this.getSchemeManager().getEntities(this.getScheme(), permission);
    }

    public String getPermissionDescription(int id) {
        return this.schemePermissions.getPermissionDescription(id);
    }

    @Override
    public SchemeManager getSchemeManager() {
        return ManagerFactory.getPermissionSchemeManager();
    }

    @Override
    public String getRedirectURL() {
        return null;
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            Scheme permissionScheme = this.getSchemeObject();
            this.projects = this.helper.getSharedProjects(permissionScheme);
        }
        return this.projects;
    }
}

