/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.mail;

import com.atlassian.gzipfilter.org.apache.commons.lang.exception.ExceptionUtils;
import com.atlassian.jira.web.action.admin.mail.VerifyMailServerConnection;
import com.atlassian.mail.MailConstants;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.impl.PopMailServerImpl;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.commons.lang.StringUtils;

public class VerifyPopServerConnection
extends VerifyMailServerConnection {
    @Override
    protected String doExecute() throws Exception {
        PopMailServerImpl mailServer = null;
        String port = this.getPort();
        String protocol = this.getProtocol();
        verifyTimeout = this.getTimeout() == null || this.getTimeout() <= 0L ? 10000L : this.getTimeout();
        MailProtocol mailProtocol = StringUtils.isNotBlank((String)protocol) ? MailProtocol.getMailProtocol((String)protocol.trim()) : MailConstants.DEFAULT_POP_PROTOCOL;
        port = StringUtils.isNotBlank((String)port) ? port.trim() : mailProtocol.getDefaultPort();
        mailServer = new PopMailServerImpl(null, this.getName(), this.getDescription(), mailProtocol, this.getServerName(), port, this.getUsername(), this.getPassword(), verifyTimeout);
        this.validateServer((MailServer)mailServer, new VerifyPopServer());
        return "success";
    }

    public String doAdd() throws Exception {
        this.doValidation();
        if (!this.hasAnyErrors()) {
            this.doExecute();
        }
        return "add";
    }

    public String doUpdate() throws Exception {
        this.doValidation();
        if (!this.hasAnyErrors()) {
            this.doExecute();
        }
        return "update";
    }

    static class VerifyPopServer
    extends VerifyMailServerConnection.VerifyMailServer {
        VerifyPopServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void verifyMailServer(MailServer server) {
            Store store = null;
            try {
                Properties props = this.getServerProperties(server);
                Session session = Session.getInstance((Properties)props, null);
                store = session.getStore(server.getMailProtocol().getProtocol());
                store.connect(server.getHostname(), Integer.parseInt(server.getPort()), server.getUsername(), server.getPassword());
            }
            catch (Exception e) {
                Throwable rootCause = e.getCause() != null ? ExceptionUtils.getRootCause((Throwable)e) : e;
                String faultMessage = String.format("%s: %s", rootCause.getClass().getSimpleName(), rootCause.getMessage());
                log.error((Object)String.format("Unable to connect to the server at %s due to the following exception: %s", server.getHostname(), rootCause.toString()));
                this.errors.add(faultMessage);
            }
            finally {
                if (store != null) {
                    try {
                        store.close();
                    }
                    catch (MessagingException messagingException) {}
                }
            }
        }
    }
}

