/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.mail.MailServerActionSupport;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.PopMailServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.log4j.Logger;

public class VerifyMailServerConnection
extends MailServerActionSupport {
    protected static long verifyTimeout;

    @Override
    public String doDefault() throws Exception {
        return "input";
    }

    protected String doExecute() throws Exception {
        return "success";
    }

    protected void validateServer(MailServer mailServer, VerifyMailServer verifier) {
        verifier.verifyMailServer(mailServer);
        if (verifier.hasErrors()) {
            this.setErrorMessages(verifier.getErrorMessages());
        }
    }

    static abstract class VerifyMailServer {
        protected final Collection<String> errors = new ArrayList<String>();
        protected static final Logger log = Logger.getLogger(VerifyMailServer.class);

        VerifyMailServer() {
        }

        public boolean hasErrors() {
            return this.errors.size() > 0;
        }

        public Collection<String> getErrorMessages() {
            return this.errors;
        }

        protected I18nHelper getI18nHelper() {
            return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        }

        public abstract void verifyMailServer(MailServer var1);

        protected Properties getServerProperties(MailServer server) {
            Properties props = new Properties();
            String protocol = server.getMailProtocol().getProtocol();
            props.put("mail." + protocol + ".host", server.getHostname());
            props.put("mail." + protocol + ".port", server.getPort());
            props.put("mail." + protocol + ".connectiontimeout", "" + verifyTimeout);
            props.put("mail." + protocol + ".timeout", "" + verifyTimeout);
            if (server instanceof PopMailServer) {
                props.put("mail.store.protocol", protocol);
            }
            return props;
        }
    }
}

