/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.mail.MailServerActionSupport;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class UpdateMailServer
extends MailServerActionSupport {
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("jira.webresources:verifymailserverconnection");
        if (this.id == null || this.id <= 0L) {
            this.addErrorMessage(this.getText("admin.errors.mail.specify.server.to.update"));
            return "error";
        }
        MailServer mailServer = MailFactory.getServerManager().getMailServer(this.id);
        if (mailServer == null) {
            this.addErrorMessage(this.getText("admin.errors.mail.error.occured.retrieving"));
            return "error";
        }
        if (this.isPop(mailServer) && this.canEditPopMailServer() || this.isSmtp(mailServer) && this.canEditSmtpMailServer()) {
            String port = StringUtils.isBlank((String)this.getPort()) ? "25" : this.getPort();
            if (this.getTimeout() == null) {
                this.setTimeout(10000L);
            }
            mailServer.setDescription(this.getDescription());
            mailServer.setName(this.getName());
            mailServer.setHostname(this.getServerName());
            mailServer.setUsername(this.getUsername());
            mailServer.setPassword(this.getPassword());
            mailServer.setPort(port);
            mailServer.setMailProtocol(MailProtocol.getMailProtocol((String)this.getProtocol()));
            mailServer.setTimeout(this.getTimeout().longValue());
            if (this.isSmtp(mailServer)) {
                SMTPMailServer smtp = (SMTPMailServer)mailServer;
                smtp.setDefaultFrom(this.getFrom());
                smtp.setPrefix(this.getPrefix());
                smtp.setTlsRequired(this.isTlsRequired());
                if (TextUtils.stringSet((String)this.getJndiLocation())) {
                    smtp.setJndiLocation(this.getJndiLocation());
                    smtp.setSessionServer(true);
                } else {
                    smtp.setJndiLocation(null);
                    smtp.setSessionServer(false);
                }
            }
            MailFactory.getServerManager().update(mailServer);
            return this.getRedirect("ViewMailServers.jspa");
        }
        return "securitybreach";
    }

    private boolean canEditSmtpMailServer() {
        return this.canManageSmtpMailServers();
    }

    private boolean canEditPopMailServer() {
        return this.canManagePopMailServers();
    }
}

