/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.mail.MailServerActionSupport;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.impl.PopMailServerImpl;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class AddMailServer
extends MailServerActionSupport {
    static final String JNDI_TIMEOUT = "60000";

    @Override
    public String doDefault() throws Exception {
        this.includeResources();
        this.setTimeout(10000L);
        return "input";
    }

    private void includeResources() {
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("jira.webresources:verifymailserverconnection");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        PopMailServerImpl mailServer;
        this.includeResources();
        MailProtocol protocol = MailProtocol.getMailProtocol((String)this.getProtocol());
        if (this.getTimeout() == null) {
            this.setTimeout(10000L);
        }
        String port = StringUtils.isNotBlank((String)this.getPort()) ? this.getPort() : protocol.getDefaultPort();
        if (this.getTypes()[0].equals(this.getType())) {
            if (!this.canAddPopMailServer()) return "securitybreach";
            mailServer = new PopMailServerImpl(null, this.getName(), this.getDescription(), protocol, this.getServerName(), port, this.getUsername(), this.getPassword(), this.getTimeout().longValue());
        } else {
            if (!this.getTypes()[1].equals(this.getType())) return "error";
            if (!this.canAddSmtpMailServer()) return "securitybreach";
            mailServer = StringUtils.isNotBlank((String)this.getJndiLocation()) ? new SMTPMailServerImpl(null, this.getName(), this.getDescription(), this.getFrom(), this.getPrefix(), true, protocol, this.getJndiLocation(), port, this.isTlsRequired(), this.getUsername(), this.getPassword(), this.getTimeout().longValue()) : new SMTPMailServerImpl(null, this.getName(), this.getDescription(), this.getFrom(), this.getPrefix(), false, protocol, this.getServerName(), port, this.isTlsRequired(), this.getUsername(), this.getPassword(), this.getTimeout().longValue());
        }
        MailFactory.getServerManager().create((MailServer)mailServer);
        return this.getRedirect("ViewMailServers.jspa");
    }

    private boolean canAddSmtpMailServer() {
        return this.canManageSmtpMailServers();
    }

    private boolean canAddPopMailServer() {
        return this.canManagePopMailServers();
    }
}

