/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.util.JiraEntityUtils;
import com.atlassian.jira.web.action.admin.issuesecurity.SchemeAwareIssueSecurityAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeleteIssueSecurityLevel
extends SchemeAwareIssueSecurityAction {
    private List affectedIssues;
    private Long levelId;
    private Long swapLevel;

    public String doExecute() throws Exception {
        GenericValue scheme;
        for (GenericValue issue : this.getAffectedIssues()) {
            issue.set("security", (Object)this.swapLevel);
            issue.store();
        }
        if (this.isDefault(this.levelId) && (scheme = this.getScheme()) != null) {
            scheme.set("defaultlevel", null);
            scheme.store();
        }
        ManagerFactory.getIndexManager().reIndexIssues((Collection)this.getAffectedIssues());
        IssueSecurityLevelManager issueSecurityLevelManager = ManagerFactory.getIssueSecurityLevelManager();
        issueSecurityLevelManager.deleteSecurityLevel(this.levelId);
        issueSecurityLevelManager.clearUsersLevels();
        return this.getRedirect(this.getRedirectURL());
    }

    public List getAffectedIssues() {
        if (this.affectedIssues == null) {
            try {
                this.affectedIssues = CoreFactory.getGenericDelegator().findByAnd("Issue", EasyMap.build((Object)"security", (Object)this.levelId));
            }
            catch (Exception e) {
                this.addErrorMessage(this.getText("admin.errors.exception") + " " + e);
                return null;
            }
        }
        return this.affectedIssues;
    }

    public Long getLevelId() {
        return this.levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    public String getIssueSecurityName() throws GenericEntityException {
        IssueSecurityLevelManager secur = ManagerFactory.getIssueSecurityLevelManager();
        return secur.getIssueSecurityName(this.levelId);
    }

    @Override
    public String getRedirectURL() {
        return "EditIssueSecurities!default.jspa?schemeId=" + this.getSchemeId();
    }

    public Map getOtherLevels() {
        Object levels = new ListOrderedMap();
        try {
            List schemeIssueSecurities = ManagerFactory.getIssueSecurityLevelManager().getSchemeIssueSecurityLevels(this.getSchemeId());
            levels = JiraEntityUtils.createEntityMap(schemeIssueSecurities, "id", "name");
            levels.remove(this.levelId);
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.issuesecurity.exception.getting.versions"));
        }
        return levels;
    }

    public Long getSwapLevel() {
        return this.swapLevel;
    }

    public void setSwapLevel(Long swapLevel) {
        this.swapLevel = swapLevel == null || swapLevel.equals(new Long(-1L)) ? null : swapLevel;
    }
}

