/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntityImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeImpl;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@WebSudoRequired
public class ViewSchemes
extends JiraWebActionSupport {
    private String fieldLayoutSchemeName;
    private String fieldLayoutSchemeDescription;
    private final FieldLayoutManager fieldLayoutManager;
    private Map schemeProjectsMap;

    public ViewSchemes(FieldLayoutManager fieldLayoutManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.schemeProjectsMap = new HashMap();
    }

    public List getFieldLayoutScheme() {
        try {
            return this.getFieldLayoutManager().getFieldLayoutSchemes();
        }
        catch (DataAccessException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.could.not.retrieve"));
            return Collections.EMPTY_LIST;
        }
    }

    public Collection getSchemeProjects(FieldLayoutScheme fieldLayoutScheme) {
        if (fieldLayoutScheme == null) {
            throw new IllegalArgumentException(this.getText("admin.errors.fieldlayout.fls.must.not.be.null"));
        }
        if (!this.schemeProjectsMap.containsKey(fieldLayoutScheme.getId())) {
            try {
                this.schemeProjectsMap.put(fieldLayoutScheme.getId(), this.getFieldLayoutManager().getProjects(fieldLayoutScheme));
            }
            catch (DataAccessException e) {
                this.log.error((Object)e, (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.fieldlayout.could.not.retrieve.projects", fieldLayoutScheme));
                return Collections.EMPTY_LIST;
            }
        }
        Collection projects = (Collection)this.schemeProjectsMap.get(fieldLayoutScheme.getId());
        Collections.sort((List)projects, OfBizComparators.NAME_COMPARATOR);
        return projects;
    }

    protected FieldLayoutManager getFieldLayoutManager() {
        return this.fieldLayoutManager;
    }

    public String doAddScheme() {
        if (!TextUtils.stringSet((String)this.getFieldLayoutSchemeName())) {
            this.addError("fieldLayoutSchemeName", this.getText("admin.common.errors.validname"));
        } else if (this.fieldLayoutManager.fieldConfigurationSchemeExists(this.getFieldLayoutSchemeName())) {
            this.addError("fieldLayoutSchemeName", this.getText("admin.errors.fieldlayout.scheme.name.exists"));
        }
        if (!this.invalidInput()) {
            FieldLayoutSchemeImpl fieldLayoutScheme = new FieldLayoutSchemeImpl(this.fieldLayoutManager, null);
            fieldLayoutScheme.setName(this.getFieldLayoutSchemeName());
            fieldLayoutScheme.setDescription(this.getFieldLayoutSchemeDescription());
            fieldLayoutScheme.store();
            FieldLayoutSchemeEntityImpl fieldLayoutSchemeEntity = new FieldLayoutSchemeEntityImpl(this.fieldLayoutManager, null, this.getConstantsManager());
            fieldLayoutSchemeEntity.setIssueTypeId(null);
            fieldLayoutSchemeEntity.setFieldLayoutId(null);
            fieldLayoutScheme.addEntity(fieldLayoutSchemeEntity);
            fieldLayoutScheme.store();
            return this.getRedirect("ViewFieldLayoutSchemes.jspa");
        }
        return this.getResult();
    }

    public String getFieldLayoutSchemeName() {
        return this.fieldLayoutSchemeName;
    }

    public void setFieldLayoutSchemeName(String fieldLayoutSchemeName) {
        this.fieldLayoutSchemeName = fieldLayoutSchemeName;
    }

    public String getFieldLayoutSchemeDescription() {
        return this.fieldLayoutSchemeDescription;
    }

    public void setFieldLayoutSchemeDescription(String fieldLayoutSchemeDescription) {
        this.fieldLayoutSchemeDescription = fieldLayoutSchemeDescription;
    }
}

