/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.AbstractFieldLayoutAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class CopyFieldLayout
extends AbstractFieldLayoutAction {
    private EditableFieldLayout editableFieldLayout;

    public CopyFieldLayout(FieldLayoutManager fieldLayoutManager) {
        super(fieldLayoutManager);
    }

    public String doDefault() throws Exception {
        this.validateFieldLayout();
        if (!this.invalidInput()) {
            this.setFieldLayoutName(ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("common.words.copyof", this.getFieldLayout().getName()));
            this.setFieldLayoutDescription(this.getFieldLayout().getDescription());
        }
        if (!this.invalidInput()) {
            return "input";
        }
        return "error";
    }

    protected void doValidation() {
        this.validateFieldLayout();
        if (!this.invalidInput()) {
            this.validateName();
            if (!this.invalidInput()) {
                for (FieldLayout fieldLayout : this.getFieldLayouts()) {
                    if (this.getId() != null && this.getId().equals(fieldLayout.getId()) || !this.getFieldLayoutName().equals(fieldLayout.getName())) continue;
                    this.addError("fieldLayoutName", this.getText("admin.errors.fieldlayout.name.exists"));
                }
            }
        }
    }

    protected String doExecute() throws Exception {
        EditableFieldLayoutImpl editableFieldLayout = new EditableFieldLayoutImpl(null, this.getFieldLayout().getFieldLayoutItems());
        editableFieldLayout.setName(this.getFieldLayoutName());
        editableFieldLayout.setDescription(this.getFieldLayoutDescription());
        this.getFieldLayoutManager().storeEditableFieldLayout((EditableFieldLayout)editableFieldLayout);
        return this.redirectToView();
    }

    @Override
    public EditableFieldLayout getFieldLayout() {
        if (this.editableFieldLayout == null) {
            this.editableFieldLayout = this.getId() == null ? this.getFieldLayoutManager().getEditableDefaultFieldLayout() : this.getFieldLayoutManager().getEditableFieldLayout(this.getId());
        }
        return this.editableFieldLayout;
    }
}

