/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.eventtype;

import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@WebSudoRequired
public class ListEventTypes
extends JiraWebActionSupport {
    private static final int SHORT_LIST_COUNT = 3;
    private final EventTypeManager eventTypeManager;
    private final WorkflowManager workflowManager;
    private final TemplateManager templateManager;
    private String name;
    private String description;
    private Long templateId;
    private String type;
    private Long eventTypeId;
    private boolean confirmed;

    public ListEventTypes(EventTypeManager eventTypeManager, WorkflowManager workflowManager, TemplateManager templateManager) {
        this.eventTypeManager = eventTypeManager;
        this.workflowManager = workflowManager;
        this.templateManager = templateManager;
    }

    protected String doExecute() throws Exception {
        return "success";
    }

    @RequiresXsrfCheck
    public String doAddEventType() {
        if (!TextUtils.stringSet((String)this.name)) {
            this.addError("name", this.getText("admin.event.types.errors.specify.name"));
        } else if (this.eventTypeManager.isEventTypeExists(this.name)) {
            this.addError("name", this.getText("admin.event.types.errors.not.unique"));
        }
        if (this.templateId == null || this.templateId == -1L) {
            this.addError("templateId", this.getText("admin.event.types.errors.select.template"));
        }
        if (this.invalidInput()) {
            return "input";
        }
        EventType newEventType = new EventType(this.name, this.description, this.templateId);
        this.eventTypeManager.addEventType(newEventType);
        this.setTemplateId(-1L);
        this.setName(null);
        this.setDescription(null);
        return this.getRedirect("ListEventTypes.jspa");
    }

    @RequiresXsrfCheck
    public String doDeleteEventType() {
        EventType eventType = this.eventTypeManager.getEventType(this.eventTypeId);
        if (!this.eventTypeManager.isActive(eventType)) {
            if (this.confirmed) {
                this.eventTypeManager.deleteEventType(this.eventTypeId);
                if (this.invalidInput()) {
                    return "error";
                }
                return this.getRedirect("ListEventTypes.jspa");
            }
            return "input";
        }
        this.addErrorMessage(this.getText("admin.event.types.errors.delete.active"));
        return "input";
    }

    @RequiresXsrfCheck
    public String doEditEventType() {
        if (this.confirmed) {
            if (TextUtils.stringSet((String)this.name)) {
                if (this.eventTypeManager.isEventTypeExists(this.name) && !this.name.equals(this.eventTypeManager.getEventType(this.eventTypeId).getName())) {
                    this.addError("name", this.getText("admin.event.types.errors.not.unique"));
                }
            } else {
                this.addError("name", this.getText("admin.event.types.errors.specify.name"));
            }
            if (this.templateId == null || this.templateId == -1L) {
                this.addError("templateId", this.getText("admin.event.types.errors.select.template"));
            }
            if (this.invalidInput()) {
                return "input";
            }
            this.eventTypeManager.editEventType(this.eventTypeId, this.name, this.description, this.templateId);
            this.setName(null);
            this.setDescription(null);
            this.setTemplateId(-1L);
            return this.getRedirect("ListEventTypes.jspa");
        }
        return "input";
    }

    public String getStepId(String workflowName, long actionDescriptorId) {
        return this.workflowManager.getStepId(actionDescriptorId, workflowName);
    }

    public List getShortList(Collection<ActionDescriptor> transitions) {
        int count = 0;
        ArrayList<ActionDescriptor> shortList = new ArrayList<ActionDescriptor>();
        for (ActionDescriptor transition : transitions) {
            shortList.add(transition);
            if (++count < 3) continue;
            break;
        }
        return shortList;
    }

    public EventTypeManager getEventTypeManager() {
        return this.eventTypeManager;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public Long getEventTypeId() {
        return this.eventTypeId;
    }

    public void setEventTypeId(Long eventTypeId) {
        this.eventTypeId = eventTypeId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }
}

