/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.action.ActionUtils;
import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.action.ActionNames;
import com.atlassian.jira.event.JiraListener;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import webwork.dispatcher.ActionResult;

@WebSudoRequired
public class ViewListeners
extends JiraWebActionSupport {
    private Collection<GenericValue> listeners;
    private Long delete;
    private String name;
    private String clazz;
    private static final Logger LOG = Logger.getLogger(ViewListeners.class);
    private final ComponentClassManager componentClassManager;
    private final ListenerManager listenerManager;

    public ViewListeners(ComponentClassManager componentClassManager, ListenerManager listenerManager) {
        this.componentClassManager = componentClassManager;
        this.listenerManager = listenerManager;
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public void setDelete(Long delete) {
        this.delete = delete;
    }

    protected void doValidation() {
        if (this.delete == null) {
            if (this.name == null || "".equals(this.name.trim())) {
                this.addError("name", this.getText("admin.errors.specify.name.for.listener"));
            }
            if (this.clazz == null || "".equals(this.clazz.trim())) {
                this.addError("clazz", this.getText("admin.errors.specify.class.for.listener"));
            }
            boolean listenerExists = false;
            for (GenericValue listenerGv : this.getListeners()) {
                if (this.name.equalsIgnoreCase(listenerGv.getString("name"))) {
                    this.addError("name", this.getText("admin.errors.listener.already.exists", this.name));
                }
                if (!this.clazz.equals(listenerGv.getString("clazz"))) continue;
                listenerExists = true;
            }
            if (!this.getHasErrors()) {
                try {
                    JiraListener listener = (JiraListener)this.componentClassManager.newInstance(this.clazz);
                    if (listenerExists && listener.isUnique()) {
                        this.addError("clazz", this.getText("admin.errors.cannot.add.listener"));
                    }
                }
                catch (ClassNotFoundException ex) {
                    this.addError("clazz", this.getText("admin.errors.class.not.found", this.clazz));
                    this.log.debug((Object)("User tried to add listener via the admin UI. The specified class [" + this.clazz + "] was not found when trying to add the listener"), (Throwable)ex);
                }
                catch (ClassCastException e) {
                    this.addError("clazz", this.getText("admin.errors.class.is.not.listener", this.clazz));
                    this.log.debug((Object)("User tried to add listener via the admin UI. The specified class [" + this.clazz + "] is not of type JiraListener"), (Throwable)e);
                }
                catch (Exception e) {
                    this.addError("clazz", this.getText("admin.errors.exception.loading.class") + " [" + e.getMessage() + "].");
                    this.log.error((Object)("User tried to add listener via the admin UI. Exception loading the specified class: [" + e.getMessage() + "]"), (Throwable)e);
                }
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.name != null && this.clazz != null) {
            try {
                ActionResult aResult = CoreFactory.getActionDispatcher().execute(ActionNames.LISTENER_CREATE, EasyMap.build((Object)"name", (Object)this.getName(), (Object)"clazz", (Object)this.getClazz()));
                ActionUtils.checkForErrors(aResult);
                this.name = null;
                this.clazz = null;
                this.listeners = null;
            }
            catch (Exception e) {
                this.addErrorMessage("Error adding listener: " + e.toString() + ".");
            }
        }
        return this.getRedirect("ViewListeners!default.jspa");
    }

    @RequiresXsrfCheck
    public String doDelete() {
        this.getOfBizDelegator().removeByAnd("ListenerConfig", (Map)ImmutableMap.of((Object)"id", (Object)this.delete));
        this.getListenerManager().refresh();
        return this.getRedirect("ViewListeners!default.jspa");
    }

    public Collection<GenericValue> getListeners() {
        if (this.listeners == null) {
            try {
                this.listeners = this.getOfBizDelegator().findAll("ListenerConfig");
            }
            catch (DataAccessException e) {
                LOG.error((Object)"DataAccessException", (Throwable)e);
            }
        }
        return this.listeners;
    }

    public JiraListener getListenerImplementation(GenericValue listener) {
        try {
            return (JiraListener)this.componentClassManager.newInstance(listener.getString("clazz"));
        }
        catch (Throwable e) {
            this.log.warn((Object)("Exception getting listener info " + e.getMessage()), e);
            return null;
        }
    }

    public boolean isListenerDeletable(GenericValue listener) {
        JiraListener listenerImp = this.getListenerImplementation(listener);
        if (listenerImp != null) {
            return !listenerImp.isInternal();
        }
        return true;
    }

    public boolean isListenerEditable(GenericValue listener) {
        JiraListener listenerImp = this.getListenerImplementation(listener);
        if (listenerImp != null) {
            return listenerImp.getAcceptedParams().length > 0;
        }
        return true;
    }

    public PropertySet getPropertySet(GenericValue gv) {
        return OFBizPropertyUtils.getPropertySet(gv);
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public void setClazz(String clazz) {
        this.clazz = clazz.trim();
    }

    public String getName() {
        return this.name;
    }

    public String getClazz() {
        return this.clazz;
    }
}

