/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.plugin.userformat.configuration.UserFormatTypeConfiguration;
import com.atlassian.jira.plugin.userformat.descriptors.UserFormatModuleDescriptors;
import com.atlassian.jira.plugin.userformat.descriptors.UserFormatTypes;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.ViewApplicationProperties;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.util.TextUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

@WebSudoRequired
public class EditLookAndFeel
extends ViewApplicationProperties {
    public static final String USER_FORMAT_PREFIX = "user_format_for_";
    public static final String GADGET_CHROME_COLOR_PREFIX = "gadgetChromeColor";
    private String logoUrl;
    private String logoWidth;
    private String logoHeight;
    private String topBgColour;
    private String topTextColour;
    private String topHighlightBgColour;
    private String topTextHighlightColour;
    private String topSeparatorColor;
    private String menuBgColour;
    private String menuTextColour;
    private String menuSeparatorColour;
    private String linkColour;
    private String linkAColour;
    private String headingColour;
    private String issuetype;
    private String summary;
    private String priority;
    private String components;
    private String versions;
    private String fixfor;
    private String assignee;
    private String environment;
    private String description;
    private String originaltimetrack;
    private String timetrack;
    private String formatTime;
    private String formatDay;
    private String formatComplete;
    private String formatDMY;
    private boolean preview = false;
    private boolean useISO8601Getter;
    private boolean useISO8601Setter;
    private static final long EXAMPLE_DATE = 1179892547906L;
    private final UserFormatManager userFormatManager;
    private final UserFormatTypeConfiguration userFormatTypeConfiguration;
    private final UserFormatTypes userFormatTypes;
    private final UserFormatModuleDescriptors userFormatModuleDescriptors;
    private final I18nHelper.BeanFactory i18nBeanFactory;

    public EditLookAndFeel(UserPickerSearchService searchService, UserFormatManager userFormatManager, UserFormatTypeConfiguration userFormatTypeConfiguration, UserFormatTypes userFormatTypes, UserFormatModuleDescriptors userFormatModuleDescriptors, I18nHelper.BeanFactory i18nBeanFactory, LocaleManager localeManager, TimeZoneService timeZoneManager, RendererManager rendererManager) {
        super(searchService, localeManager, timeZoneManager, rendererManager);
        this.userFormatManager = userFormatManager;
        this.userFormatTypeConfiguration = userFormatTypeConfiguration;
        this.userFormatTypes = userFormatTypes;
        this.userFormatModuleDescriptors = userFormatModuleDescriptors;
        this.i18nBeanFactory = i18nBeanFactory;
    }

    public String doDefault() throws Exception {
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.getApplicationProperties());
        this.logoUrl = lookAndFeelBean.getLogoUrl();
        this.logoWidth = lookAndFeelBean.getLogoWidth();
        this.logoHeight = lookAndFeelBean.getLogoHeight();
        this.topBgColour = lookAndFeelBean.getTopBackgroundColour();
        this.topTextColour = lookAndFeelBean.getTopTxtColour();
        this.topHighlightBgColour = lookAndFeelBean.getTopHighlightColor();
        this.topTextHighlightColour = lookAndFeelBean.getTopTextHighlightColor();
        this.topSeparatorColor = lookAndFeelBean.getTopSeparatorBackgroundColor();
        this.menuBgColour = lookAndFeelBean.getMenuBackgroundColour();
        this.menuSeparatorColour = lookAndFeelBean.getMenuSeparatorColour();
        this.menuTextColour = lookAndFeelBean.getMenuTxtColour();
        this.linkColour = lookAndFeelBean.getTextLinkColour();
        this.linkAColour = lookAndFeelBean.getTextActiveLinkColour();
        this.headingColour = lookAndFeelBean.getTextHeadingColour();
        this.issuetype = this.getApplicationProperties().getString("jira.issue.desc.issuetype");
        this.summary = this.getApplicationProperties().getString("jira.issue.desc.summary");
        this.priority = this.getApplicationProperties().getString("jira.issue.desc.priority");
        this.components = this.getApplicationProperties().getString("jira.issue.desc.components");
        this.versions = this.getApplicationProperties().getString("jira.issue.desc.versions");
        this.fixfor = this.getApplicationProperties().getString("jira.issue.desc.fixfor");
        this.assignee = this.getApplicationProperties().getString("jira.issue.desc.assignee");
        this.environment = this.getApplicationProperties().getString("jira.issue.desc.environment");
        this.description = this.getApplicationProperties().getString("jira.issue.desc.description");
        this.originaltimetrack = this.getApplicationProperties().getString("jira.issue.desc.original.timetrack");
        this.timetrack = this.getApplicationProperties().getString("jira.issue.desc.timetrack");
        this.formatTime = this.getApplicationProperties().getString("jira.lf.date.time");
        this.formatDay = this.getApplicationProperties().getString("jira.lf.date.day");
        this.formatComplete = this.getApplicationProperties().getString("jira.lf.date.complete");
        this.formatDMY = this.getApplicationProperties().getString("jira.lf.date.dmy");
        this.useISO8601Getter = this.getApplicationProperties().getOption("jira.date.time.picker.use.iso8061");
        return super.doDefault();
    }

    protected void doValidation() {
        boolean logoSet = TextUtils.stringSet((String)this.logoUrl);
        if (!TextUtils.stringSet((String)this.logoWidth)) {
            if (logoSet) {
                this.addError("logoWidth", this.getI18n().getText("admin.errors.must.specify.logo.width"));
            }
        } else {
            try {
                int width = Integer.parseInt(this.logoWidth);
                if (width < 0) {
                    this.addError("logoWidth", this.getI18n().getText("admin.errors.logo.width.must.be.number"));
                }
            }
            catch (NumberFormatException e) {
                this.addError("logoWidth", this.getI18n().getText("admin.errors.logo.width.must.be.number"));
            }
        }
        if (!TextUtils.stringSet((String)this.logoHeight)) {
            if (logoSet) {
                this.addError("logoHeight", this.getI18n().getText("admin.errors.must.specify.logo.height"));
            }
        } else {
            try {
                int height = Integer.parseInt(this.logoHeight);
                if (height < 0) {
                    this.addError("logoHeight", this.getI18n().getText("admin.errors.logo.height.must.be.number"));
                }
            }
            catch (NumberFormatException e) {
                this.addError("logoHeight", this.getI18n().getText("admin.errors.logo.height.must.be.number"));
            }
        }
        if (!this.validateDateFormat(this.formatTime)) {
            this.addError("formatTime", this.getI18n().getText("admin.errors.must.specify.a.valid.time.format"));
        }
        if (!this.validateDateFormat(this.formatDay)) {
            this.addError("formatDay", this.getI18n().getText("admin.errors.must.specify.a.valid.day.format"));
        }
        if (!this.validateDateFormat(this.formatComplete)) {
            this.addError("formatComplete", this.getI18n().getText("admin.errors.must.specify.a.complete.date.time.format"));
        }
        if (!this.validateDateFormat(this.formatDMY)) {
            this.addError("formatDMY", this.getI18n().getText("admin.errors.must.specify.a.valid.date.format"));
        }
        super.doValidation();
    }

    private boolean validateDateFormat(String format) {
        if (TextUtils.stringSet((String)format)) {
            try {
                new SimpleDateFormat(format);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    @RequiresXsrfCheck
    public String doReset() throws Exception {
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.getApplicationProperties());
        lookAndFeelBean.setLogoUrl(null);
        lookAndFeelBean.setLogoWidth(null);
        lookAndFeelBean.setLogoHeight(null);
        lookAndFeelBean.setFaviconHiResUrl(null);
        lookAndFeelBean.setFaviconUrl(null);
        lookAndFeelBean.setTopBackgroundColour(null);
        lookAndFeelBean.setTopTxtColour(null);
        lookAndFeelBean.setTopHighlightColor(null);
        lookAndFeelBean.setTopTextHighlightColor(null);
        lookAndFeelBean.setTopSeparatorBackgroundColor(null);
        lookAndFeelBean.setMenuBackgroundColour(null);
        lookAndFeelBean.setMenuTxtColour(null);
        lookAndFeelBean.setMenuSeparatorColour(null);
        lookAndFeelBean.setTextLinkColour(null);
        lookAndFeelBean.setTextActiveLinkColour(null);
        lookAndFeelBean.setTextHeadingColour(null);
        this.getApplicationProperties().setString("jira.issue.desc.issuetype", null);
        this.getApplicationProperties().setString("jira.issue.desc.summary", null);
        this.getApplicationProperties().setString("jira.issue.desc.priority", null);
        this.getApplicationProperties().setString("jira.issue.desc.components", null);
        this.getApplicationProperties().setString("jira.issue.desc.versions", null);
        this.getApplicationProperties().setString("jira.issue.desc.fixfor", null);
        this.getApplicationProperties().setString("jira.issue.desc.assignee", null);
        this.getApplicationProperties().setString("jira.issue.desc.environment", null);
        this.getApplicationProperties().setString("jira.issue.desc.description", null);
        this.getApplicationProperties().setString("jira.issue.desc.original.timetrack", null);
        this.getApplicationProperties().setString("jira.issue.desc.timetrack", null);
        this.getApplicationProperties().setString("jira.lf.date.time", null);
        this.getApplicationProperties().setString("jira.lf.date.day", null);
        this.getApplicationProperties().setString("jira.lf.date.complete", null);
        this.getApplicationProperties().setString("jira.lf.date.dmy", null);
        this.getApplicationProperties().setOption("jira.date.time.picker.use.iso8061", false);
        for (Color color : Color.values()) {
            lookAndFeelBean.setGadgetChromeColor(color.toString(), null);
        }
        ManagerFactory.getOutlookDateManager().refresh();
        return this.getRedirect("ViewLookAndFeel.jspa");
    }

    @RequiresXsrfCheck
    public String doRefreshResources() throws Exception {
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.getApplicationProperties());
        lookAndFeelBean.setMenuBackgroundColour(lookAndFeelBean.getMenuBackgroundColour());
        return this.getRedirect("ViewLookAndFeel.jspa?refreshResourcesPerformed=true");
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        String newValue;
        if (this.preview) {
            this.preview = false;
            return "input";
        }
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.getApplicationProperties());
        String string = newValue = TextUtils.stringSet((String)this.logoUrl) ? this.logoUrl : null;
        if (this.hasChanged(lookAndFeelBean.getLogoUrl(), newValue)) {
            lookAndFeelBean.setLogoUrl(newValue);
        }
        String string2 = newValue = TextUtils.stringSet((String)this.logoWidth) ? this.logoWidth : null;
        if (this.hasChanged(lookAndFeelBean.getLogoWidth(), newValue)) {
            lookAndFeelBean.setLogoWidth(newValue);
        }
        String string3 = newValue = TextUtils.stringSet((String)this.logoHeight) ? this.logoHeight : null;
        if (this.hasChanged(lookAndFeelBean.getLogoHeight(), newValue)) {
            lookAndFeelBean.setLogoHeight(newValue);
        }
        newValue = this.formatColorCode(this.topBgColour);
        if (this.hasChanged(lookAndFeelBean.getTopBackgroundColour(), newValue)) {
            lookAndFeelBean.setTopBackgroundColour(newValue);
        }
        newValue = this.formatColorCode(this.topTextColour);
        if (this.hasChanged(lookAndFeelBean.getTopTxtColour(), newValue)) {
            lookAndFeelBean.setTopTxtColour(newValue);
        }
        newValue = this.formatColorCode(this.topHighlightBgColour);
        if (this.hasChanged(lookAndFeelBean.getTopHighlightColor(), newValue)) {
            lookAndFeelBean.setTopHighlightColor(newValue);
        }
        newValue = this.formatColorCode(this.topTextHighlightColour);
        if (this.hasChanged(lookAndFeelBean.getTopTextHighlightColor(), newValue)) {
            lookAndFeelBean.setTopTextHighlightColor(newValue);
        }
        newValue = this.formatColorCode(this.topSeparatorColor);
        if (this.hasChanged(lookAndFeelBean.getTopSeparatorBackgroundColor(), newValue)) {
            lookAndFeelBean.setTopSeparatorBackgroundColor(newValue);
        }
        newValue = this.formatColorCode(this.menuBgColour);
        if (this.hasChanged(lookAndFeelBean.getMenuBackgroundColour(), newValue)) {
            lookAndFeelBean.setMenuBackgroundColour(newValue);
        }
        newValue = this.formatColorCode(this.menuSeparatorColour);
        if (this.hasChanged(lookAndFeelBean.getMenuSeparatorColour(), newValue)) {
            lookAndFeelBean.setMenuSeparatorColour(newValue);
        }
        newValue = this.formatColorCode(this.menuTextColour);
        if (this.hasChanged(lookAndFeelBean.getMenuTxtColour(), newValue)) {
            lookAndFeelBean.setMenuTxtColour(newValue);
        }
        newValue = this.formatColorCode(this.linkColour);
        if (this.hasChanged(lookAndFeelBean.getTextLinkColour(), newValue)) {
            lookAndFeelBean.setTextLinkColour(newValue);
        }
        newValue = this.formatColorCode(this.linkAColour);
        if (this.hasChanged(lookAndFeelBean.getTextActiveLinkColour(), newValue)) {
            lookAndFeelBean.setTextActiveLinkColour(newValue);
        }
        newValue = this.formatColorCode(this.headingColour);
        if (this.hasChanged(lookAndFeelBean.getTextHeadingColour(), newValue)) {
            lookAndFeelBean.setTextHeadingColour(newValue);
        }
        ApplicationProperties ap = this.getApplicationProperties();
        ap.setString("jira.issue.desc.issuetype", TextUtils.stringSet((String)this.issuetype) ? this.issuetype : null);
        ap.setString("jira.issue.desc.summary", TextUtils.stringSet((String)this.summary) ? this.summary : null);
        ap.setString("jira.issue.desc.priority", TextUtils.stringSet((String)this.priority) ? this.priority : null);
        ap.setString("jira.issue.desc.components", TextUtils.stringSet((String)this.components) ? this.components : null);
        ap.setString("jira.issue.desc.versions", TextUtils.stringSet((String)this.versions) ? this.versions : null);
        ap.setString("jira.issue.desc.fixfor", TextUtils.stringSet((String)this.fixfor) ? this.fixfor : null);
        ap.setString("jira.issue.desc.assignee", TextUtils.stringSet((String)this.assignee) ? this.assignee : null);
        ap.setString("jira.issue.desc.environment", TextUtils.stringSet((String)this.environment) ? this.environment : null);
        ap.setString("jira.issue.desc.description", TextUtils.stringSet((String)this.description) ? this.description : null);
        ap.setString("jira.issue.desc.original.timetrack", TextUtils.stringSet((String)this.originaltimetrack) ? this.originaltimetrack : null);
        ap.setString("jira.issue.desc.timetrack", TextUtils.stringSet((String)this.timetrack) ? this.timetrack : null);
        ap.setString("jira.lf.date.time", TextUtils.stringSet((String)this.formatTime) ? this.formatTime : null);
        ap.setString("jira.lf.date.day", TextUtils.stringSet((String)this.formatDay) ? this.formatDay : null);
        ap.setString("jira.lf.date.complete", TextUtils.stringSet((String)this.formatComplete) ? this.formatComplete : null);
        ap.setString("jira.lf.date.dmy", TextUtils.stringSet((String)this.formatDMY) ? this.formatDMY : null);
        ap.setOption("jira.date.time.picker.use.iso8061", this.useISO8601Setter);
        this.setUserFormat(ActionContext.getParameters());
        this.setGadgetChromeColors(ActionContext.getParameters());
        ManagerFactory.getOutlookDateManager().refresh();
        return this.getRedirect("ViewLookAndFeel.jspa");
    }

    private boolean hasChanged(String value1, String value2) {
        return value1 == null ? value2 != null : !value1.equals(value2);
    }

    private String formatColorCode(String color) {
        if (TextUtils.stringSet((String)color)) {
            return this.makeValidColor(color);
        }
        return null;
    }

    private String makeValidColor(String color) {
        int len = (color = (color = color.trim()).startsWith("#") ? color : "#" + color).length();
        if (len > 7) {
            color = color.substring(0, 7);
        } else if (len == 4) {
            char[] chars = color.toCharArray();
            color = "#" + chars[1] + chars[1] + chars[2] + chars[2] + chars[3] + chars[3];
        } else if (len < 7) {
            StringBuffer sb = new StringBuffer(color);
            for (int i = len; i < 7; ++i) {
                sb.append("0");
            }
            color = sb.toString();
        }
        return color;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        if (TextUtils.stringSet((String)logoUrl) && !logoUrl.startsWith("http") && !logoUrl.startsWith("/")) {
            logoUrl = "/" + logoUrl;
        }
        this.logoUrl = logoUrl;
    }

    public String getLogoWidth() {
        return this.logoWidth;
    }

    public void setLogoWidth(String logoWidth) {
        this.logoWidth = logoWidth;
    }

    public String getLogoHeight() {
        return this.logoHeight;
    }

    public void setLogoHeight(String logoHeight) {
        this.logoHeight = logoHeight;
    }

    public String getTopBgColour() {
        return this.topBgColour;
    }

    public void setTopBgColour(String topBgColour) {
        this.topBgColour = topBgColour;
    }

    public String getMenuBgColour() {
        return this.menuBgColour;
    }

    public void setMenuBgColour(String menuBgColour) {
        this.menuBgColour = menuBgColour;
    }

    public String getMenuSeparatorColour() {
        return this.menuSeparatorColour;
    }

    public void setMenuSeparatorColour(String menuSeparatorColour) {
        this.menuSeparatorColour = menuSeparatorColour;
    }

    public String getMenuTextColour() {
        return this.menuTextColour;
    }

    public void setMenuTextColour(String menuTextColour) {
        this.menuTextColour = menuTextColour;
    }

    public String getTopTextColour() {
        return this.topTextColour;
    }

    public void setTopTextColour(String topTextColour) {
        this.topTextColour = topTextColour;
    }

    public String getIssuetype() {
        return this.issuetype;
    }

    public void setIssuetype(String issuetype) {
        this.issuetype = issuetype;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getComponents() {
        return this.components;
    }

    public void setComponents(String components) {
        this.components = components;
    }

    public String getVersions() {
        return this.versions;
    }

    public void setVersions(String versions) {
        this.versions = versions;
    }

    public String getFixfor() {
        return this.fixfor;
    }

    public void setFixfor(String fixfor) {
        this.fixfor = fixfor;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOriginaltimetrack() {
        return this.originaltimetrack;
    }

    public void setOriginaltimetrack(String originaltimetrack) {
        this.originaltimetrack = originaltimetrack;
    }

    public String getTimetrack() {
        return this.timetrack;
    }

    public void setTimetrack(String timetrack) {
        this.timetrack = timetrack;
    }

    public String getLinkColour() {
        return this.linkColour;
    }

    public void setLinkColour(String linkColour) {
        this.linkColour = linkColour;
    }

    public String getLinkAColour() {
        return this.linkAColour;
    }

    public void setLinkAColour(String linkAColour) {
        this.linkAColour = linkAColour;
    }

    public String getHeadingColour() {
        return this.headingColour;
    }

    public void setHeadingColour(String headingColour) {
        this.headingColour = headingColour;
    }

    public String getFormatTime() {
        return this.formatTime;
    }

    public void setFormatTime(String formatTime) {
        this.formatTime = formatTime;
    }

    public String getFormatDay() {
        return this.formatDay;
    }

    public void setFormatDay(String formatDay) {
        this.formatDay = formatDay;
    }

    public String getFormatComplete() {
        return this.formatComplete;
    }

    public void setFormatComplete(String formatComplete) {
        this.formatComplete = formatComplete;
    }

    public String getFormatDMY() {
        return this.formatDMY;
    }

    public void setFormatDMY(String formatDMY) {
        this.formatDMY = formatDMY;
    }

    public static Date getExampleDate() {
        return new Date(1179892547906L);
    }

    public String getTopHighlightBgColour() {
        return this.topHighlightBgColour;
    }

    public void setTopHighlightBgColour(String topHighlightBgColour) {
        this.topHighlightBgColour = topHighlightBgColour;
    }

    public String getTopTextHighlightColour() {
        return this.topTextHighlightColour;
    }

    public void setTopTextHighlightColour(String newValue) {
        this.topTextHighlightColour = newValue;
    }

    public String getTopSeparatorColor() {
        return this.topSeparatorColor;
    }

    public void setTopSeparatorColor(String topSeparatorColor) {
        this.topSeparatorColor = topSeparatorColor;
    }

    public String getUserFormatTypeName(String type) {
        String typeI18nKey;
        UserFormatModuleDescriptor descriptor = this.userFormatModuleDescriptors.withKey(this.userFormatTypeConfiguration.getUserFormatKeyForType(type));
        if (descriptor != null && StringUtils.isNotEmpty((String)(typeI18nKey = descriptor.getTypeI18nKey()))) {
            return this.getI18n().getText(typeI18nKey);
        }
        return type;
    }

    public String getUserFormatName(String type) {
        UserFormatModuleDescriptor descriptor = this.userFormatModuleDescriptors.withKey(this.userFormatTypeConfiguration.getUserFormatKeyForType(type));
        if (descriptor != null) {
            String nameKey = descriptor.getI18nNameKey();
            if (StringUtils.isNotEmpty((String)nameKey)) {
                return this.getI18n().getText(nameKey);
            }
            return descriptor.getName();
        }
        return type;
    }

    public String getUserFormatKey(String type) {
        UserFormatModuleDescriptor descriptor = this.userFormatModuleDescriptors.withKey(this.userFormatTypeConfiguration.getUserFormatKeyForType(type));
        if (descriptor != null) {
            return descriptor.getCompleteKey();
        }
        return type;
    }

    public Collection getUserFormatModuleDescriptorsForType(String type) {
        return ImmutableList.copyOf(this.userFormatModuleDescriptors.forType(type));
    }

    public String getCurrentUserFormatForType(String type) {
        return this.userFormatTypeConfiguration.getUserFormatKeyForType(type);
    }

    public Set<String> getUserFormatTypes() {
        return ImmutableSet.copyOf(this.userFormatTypes.get());
    }

    public String getSampleUserFormat(String type) {
        User remoteUser = this.getLoggedInUser();
        return this.userFormatManager.formatUser(Users.isAnonymous((User)remoteUser) ? null : remoteUser.getName(), type, "look_and_feel");
    }

    public boolean hasUserFormatsToEdit() {
        Set<String> types = this.getUserFormatTypes();
        for (String type1 : types) {
            String type = type1;
            if (this.getUserFormatModuleDescriptorsForType(type).size() <= 1) continue;
            return true;
        }
        return false;
    }

    public List<Color> getGadgetColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (Color color : Color.values()) {
            if (color.equals((Object)Color.color8)) continue;
            colors.add(color);
        }
        return colors;
    }

    public String getGadgetColor(Color colorId) {
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.getApplicationProperties());
        String gadgetColor = lookAndFeelBean.getGadgetChromeColor(colorId.toString());
        if (StringUtils.isBlank((String)gadgetColor)) {
            gadgetColor = "";
        }
        return gadgetColor;
    }

    public String getLookAndFeelVersionNumber() {
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.getApplicationProperties());
        return lookAndFeelBean.getVersion() + "";
    }

    private void setUserFormat(Map parameters) {
        Set set = parameters.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            if (!key.startsWith(USER_FORMAT_PREFIX)) continue;
            String type = key.substring(USER_FORMAT_PREFIX.length());
            try {
                this.userFormatTypeConfiguration.setUserFormatKeyForType(type, ((String[])entry.getValue())[0]);
            }
            catch (IllegalArgumentException e) {
                this.addError(USER_FORMAT_PREFIX + type, this.getI18n().getText("admin.globalsettings.lookandfeel.error.invalid.user.format"));
            }
        }
    }

    private void setGadgetChromeColors(Map parameters) {
        Set set = parameters.entrySet();
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.getApplicationProperties());
        for (Map.Entry entry : set) {
            String newValue;
            String key = (String)entry.getKey();
            if (!key.startsWith(GADGET_CHROME_COLOR_PREFIX)) continue;
            String colorId = key.substring(GADGET_CHROME_COLOR_PREFIX.length());
            String[] values = (String[])entry.getValue();
            String value = values != null && values.length > 0 ? values[0] : null;
            String string = newValue = StringUtils.isNotBlank(value) ? value : null;
            if (!this.hasChanged(lookAndFeelBean.getGadgetChromeColor(colorId), newValue)) continue;
            lookAndFeelBean.setGadgetChromeColor(colorId, value);
        }
    }

    private I18nHelper getI18n() {
        return this.i18nBeanFactory.getInstance(this.getLoggedInUser());
    }

    public boolean getUseISO8601() {
        return this.useISO8601Getter;
    }

    public void setUseISO8601(boolean useISO8061) {
        this.useISO8601Setter = useISO8061;
    }
}

