/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.upgrade.BuildNumComparator;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventType;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import webwork.action.ServletActionContext;

public class ConfirmNewInstallationWithOldLicense
extends JiraWebActionSupport {
    private static final String CROWD_EMBEDDED_INTEGRATION_VERSION = "602";
    private String userName;
    private String password;
    private String license;
    private String confirm;
    private boolean licenseUpdated = false;
    private boolean installationConfirmed = false;
    private LicenseDetails licenseDetails;
    private JiraLicenseService.ValidationResult validationResult;
    private final JiraLicenseUpdaterService jiraLicenseService;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraSystemRestarter jiraSystemRestarter;
    private final CrowdService crowdService;

    public ConfirmNewInstallationWithOldLicense(JiraLicenseUpdaterService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, JiraSystemRestarter jiraSystemRestarter, CrowdService crowdService) {
        this.crowdService = crowdService;
        this.jiraLicenseService = (JiraLicenseUpdaterService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.jiraSystemRestarter = (JiraSystemRestarter)Assertions.notNull((String)"jiraSystemRestarter", (Object)jiraSystemRestarter);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLicense() {
        return this.license;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public boolean isLicenseUpdated() {
        return this.licenseUpdated;
    }

    public boolean isInstallationConfirmed() {
        return this.installationConfirmed;
    }

    protected void doValidation() {
        if (this.getUserInfoAvailable()) {
            boolean hasAdminPermission;
            User user = this.crowdService.getUser(this.userName);
            if (user == null) {
                this.addErrorMessage(this.getText("admin.errors.invalid.username.or.pasword"));
                return;
            }
            try {
                this.crowdService.authenticate(this.userName, this.password);
            }
            catch (FailedAuthenticationException e) {
                this.addErrorMessage(this.getText("admin.errors.invalid.username.or.pasword"));
                return;
            }
            if (!this.nonAdminUpgradeAllowed() && !(hasAdminPermission = ManagerFactory.getPermissionManager().hasPermission(0, user))) {
                this.addError("userName", this.getText("admin.errors.no.admin.permission"));
            }
        }
        if (StringUtils.isNotBlank((String)this.license)) {
            this.validationResult = this.jiraLicenseService.validate((I18nHelper)this, this.license);
            this.addErrorCollection(this.validationResult.getErrorCollection());
        } else if (StringUtils.isBlank((String)this.confirm)) {
            this.log.warn((Object)"Neither the License nor the Install Confirmation have been supplied.");
            this.addErrorMessage(this.getText("admin.errors.no.license"));
        }
    }

    private boolean nonAdminUpgradeAllowed() {
        return Boolean.valueOf(System.getProperty("non.admin.upgrade"));
    }

    public String doExecute() throws Exception {
        if (StringUtils.isNotBlank((String)this.license)) {
            this.licenseDetails = this.jiraLicenseService.setLicense(this.validationResult);
            if (!this.licenseDetails.isMaintenanceValidForBuildDate(this.buildUtilsInfo.getCurrentBuildDate())) {
                this.addError("license", this.getText("admin.errors.license.too.old"));
                return "error";
            }
            this.licenseUpdated = true;
        } else if (StringUtils.isNotBlank((String)this.confirm)) {
            this.jiraLicenseService.confirmProceedUnderEvaluationTerms(this.userName);
            this.installationConfirmed = true;
        } else {
            throw new IllegalStateException("This will never happen!");
        }
        this.jiraSystemRestarter.ariseSirJIRA();
        JohnsonEventContainer cont = JohnsonEventContainer.get((ServletContext)ServletActionContext.getServletContext());
        for (Object o : cont.getEvents()) {
            Event event = (Event)o;
            if (event == null || !event.getKey().equals((Object)EventType.get((String)"license-too-old"))) continue;
            cont.removeEvent(event);
        }
        return "success";
    }

    public LicenseDetails getLicenseDetails() {
        if (this.licenseDetails == null) {
            this.licenseDetails = this.jiraLicenseService.getLicense();
        }
        return this.licenseDetails;
    }

    public String getLicenseStatusMessage() {
        return this.getLicenseDetails().getLicenseStatusMessage(this.getLoggedInUser(), "<br/>");
    }

    public BuildUtilsInfo getBuildUtilsInfo() {
        return this.buildUtilsInfo;
    }

    public String getCurrentBuildDate() {
        return this.getOutlookDate().formatDMY(this.buildUtilsInfo.getCurrentBuildDate());
    }

    public boolean getUserInfoAvailable() {
        BuildNumComparator comparator = new BuildNumComparator();
        if (comparator.compare(this.buildUtilsInfo.getCurrentBuildNumber(), CROWD_EMBEDDED_INTEGRATION_VERSION) < 0) {
            return true;
        }
        String currentDatabaseVersion = this.getApplicationProperties().getString("jira.version.patched");
        return currentDatabaseVersion == null ? false : comparator.compare(currentDatabaseVersion, CROWD_EMBEDDED_INTEGRATION_VERSION) > 0;
    }
}

