/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.system.VersionNumber;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.opensymphony.util.TextUtils;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.log4j.Level;

public class PluginVersionCheck {
    private final JiraStartupLogger startupLog = new JiraStartupLogger();
    private final PluginAccessor pluginAccessor;
    private final BuildUtilsInfo buildUtilsInfo;
    private static final String PAC_LINK = "https://plugins.atlassian.com/search/by/jira";
    private final Map<String, PluginPredicate<Plugin>> pluginsToCheck = new LinkedHashMap<String, PluginPredicate<Plugin>>();

    public PluginVersionCheck(PluginAccessor pluginAccessor, BuildUtilsInfo buildUtilsInfo) {
        this.pluginAccessor = (PluginAccessor)Assertions.notNull((String)"pluginAccessor", (Object)pluginAccessor);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.pluginsToCheck.put("com.atlassian.jira.ext.charting", new MinVersionCheckPredicate(buildUtilsInfo));
        this.pluginsToCheck.put("com.atlassian.jira.plugin.labels", new BlackListPredicate());
    }

    public void check(ServletContext context) {
        HashSet<Plugin> outdatedPlugins = new HashSet<Plugin>();
        for (Map.Entry<String, PluginPredicate<Plugin>> pluginEntry : this.pluginsToCheck.entrySet()) {
            Plugin plugin = this.pluginAccessor.getPlugin(pluginEntry.getKey());
            if (plugin == null || !pluginEntry.getValue().evaluate(plugin)) continue;
            outdatedPlugins.add(plugin);
        }
        if (!outdatedPlugins.isEmpty()) {
            this.addErrors(context, outdatedPlugins);
        }
    }

    void addErrors(ServletContext context, Set<Plugin> outdatedPlugins) {
        String description = "Plugins found that are not compatible with JIRA v" + this.buildUtilsInfo.getVersion() + ".  " + "The following plugins need to be either removed or updated in order for JIRA to start successfully:";
        StringBuffer pluginNames = new StringBuffer();
        for (Plugin outdatedPlugin : outdatedPlugins) {
            pluginNames.append(this.pluginsToCheck.get(outdatedPlugin.getKey()).getErrorMessage(outdatedPlugin)).append("\n");
        }
        String cacMessage = "Please visit https://plugins.atlassian.com/search/by/jira to download the latest versions of these plugins.";
        List messages = CollectionBuilder.newBuilder((Object[])new String[]{"", description, "", pluginNames.toString().trim(), "", "Please visit https://plugins.atlassian.com/search/by/jira to download the latest versions of these plugins.", ""}).asList();
        this.startupLog.printMessage(messages, Level.ERROR);
        Event event = new Event(EventType.get((String)"outdated-plugins-installed"), description + "<p/>" + TextUtils.plainTextToHtml((String)pluginNames.toString()) + "<p/>" + TextUtils.plainTextToHtml((String)"Please visit https://plugins.atlassian.com/search/by/jira to download the latest versions of these plugins."), EventLevel.get((String)"error"));
        JohnsonEventContainer eventCont = JohnsonEventContainer.get((ServletContext)context);
        if (eventCont != null) {
            eventCont.addEvent(event);
        }
    }

    static class MinVersionCheckPredicate
    implements PluginPredicate<Plugin> {
        private final BuildUtilsInfo buildUtilsInfo;

        MinVersionCheckPredicate(BuildUtilsInfo buildUtilsInfo) {
            this.buildUtilsInfo = buildUtilsInfo;
        }

        public boolean evaluate(Plugin input) {
            String minVersionStr = Float.toString(input.getPluginInformation().getMinVersion());
            VersionNumber pluginMinVersion = new VersionNumber(minVersionStr);
            VersionNumber appVersion = new VersionNumber(this.getJiraVersionStringWithoutSuffix());
            return pluginMinVersion.isGreaterThan(appVersion);
        }

        private String getJiraVersionStringWithoutSuffix() {
            String version = this.buildUtilsInfo.getVersion();
            if (version.contains("-")) {
                return version.substring(0, version.indexOf("-"));
            }
            return version;
        }

        @Override
        public String getErrorMessage(Plugin input) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("* ").append(input.getName()).append(" (").append(input.getKey()).append(")");
            float pluginMinVersion = input.getPluginInformation().getMinVersion();
            String pluginVersion = input.getPluginInformation().getVersion();
            errorMessage.append(" v").append(pluginVersion).append(" - requires JIRA v").append(pluginMinVersion).append(" minimum");
            return errorMessage.toString();
        }
    }

    static class BlackListPredicate
    implements PluginPredicate<Plugin> {
        BlackListPredicate() {
        }

        public boolean evaluate(Plugin input) {
            return true;
        }

        @Override
        public String getErrorMessage(Plugin input) {
            return "* The plugin '" + input.getName() + "' (" + input.getKey() + ") is no longer compatible with this version of JIRA and needs to be removed. Its functionality has been incorporated into JIRA core.";
        }
    }

    static interface PluginPredicate<T>
    extends Predicate<T> {
        public String getErrorMessage(T var1);
    }
}

