/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.log;

import com.atlassian.jira.util.dbc.Null;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class NShotLogger {
    private final Logger delegateLogger;
    private final AtomicLong callCount;
    private final long maxTimes;

    public NShotLogger(Logger delegateLogger, int maxTimes) {
        Null.not("delegateLogger", delegateLogger);
        if (maxTimes <= 0) {
            throw new IllegalArgumentException("Come on now you have to provide a sensible maxTimes  ==> " + maxTimes);
        }
        this.delegateLogger = delegateLogger;
        this.maxTimes = maxTimes;
        this.callCount = new AtomicLong(0L);
    }

    public Logger getDelegateLogger() {
        return this.delegateLogger;
    }

    public void debug(Object o) {
        if (this.callCount.getAndIncrement() < this.maxTimes) {
            this.delegateLogger.debug(o);
        }
    }

    public void debug(Object o, Throwable throwable) {
        if (this.callCount.getAndIncrement() < this.maxTimes) {
            this.delegateLogger.debug(o, throwable);
        }
    }

    public void error(Object o) {
        if (this.callCount.getAndIncrement() < this.maxTimes) {
            this.delegateLogger.error(o);
        }
    }

    public void error(Object o, Throwable throwable) {
        if (this.callCount.getAndIncrement() < this.maxTimes) {
            this.delegateLogger.error(o, throwable);
        }
    }

    public void fatal(Object o) {
        if (this.callCount.getAndIncrement() < this.maxTimes) {
            this.delegateLogger.fatal(o);
        }
    }

    public void fatal(Object o, Throwable throwable) {
        if (this.callCount.getAndIncrement() < this.maxTimes) {
            this.delegateLogger.fatal(o, throwable);
        }
    }

    public void info(Object o) {
        if (this.callCount.getAndIncrement() < this.maxTimes) {
            this.delegateLogger.info(o);
        }
    }

    public void info(Object o, Throwable throwable) {
        if (this.callCount.getAndIncrement() < this.maxTimes) {
            this.delegateLogger.info(o, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.delegateLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegateLogger.isInfoEnabled();
    }

    public boolean isEnabledFor(Priority priority) {
        return this.delegateLogger.isEnabledFor(priority);
    }

    public void warn(Object o) {
        if (this.callCount.getAndIncrement() < this.maxTimes) {
            this.delegateLogger.warn(o);
        }
    }

    public void warn(Object o, Throwable throwable) {
        if (this.callCount.getAndIncrement() < this.maxTimes) {
            this.delegateLogger.warn(o, throwable);
        }
    }
}

