/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.core.util.Clock;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.RealClock;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.opensymphony.module.propertyset.PropertySet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

class PasswordResetTokenBuilder {
    private static final Logger log = Logger.getLogger(PasswordResetTokenBuilder.class);
    private static final int TOKEN_EXPIRY_HOURS = 24;
    private static final String PASSWORD_RESET_REQUEST_TOKEN = "password.reset.request.token";
    private static final String PASSWORD_RESET_REQUEST_EXPIRY = "password.reset.request.expiry";
    private final Clock clock;
    private final CrowdService crowdService;

    PasswordResetTokenBuilder(CrowdService crowdService) {
        this(RealClock.getInstance(), crowdService);
    }

    PasswordResetTokenBuilder(Clock clock, CrowdService crowdService) {
        this.clock = clock;
        this.crowdService = crowdService;
    }

    UserUtil.PasswordResetToken generateToken(final User user) {
        Assertions.notNull((String)"user", (Object)user);
        final String token = this.genSecureToken();
        final long expiryTime = this.genExpiryTime();
        this.recordToken(user, token, expiryTime);
        return new UserUtil.PasswordResetToken(){

            public User getUser() {
                return user;
            }

            public String getToken() {
                return token;
            }

            public int getExpiryHours() {
                return 24;
            }

            public long getExpiryTime() {
                return expiryTime;
            }
        };
    }

    UserUtil.PasswordResetTokenValidation.Status validateToken(User user, String token) {
        Assertions.notNull((String)"user", (Object)user);
        String storedToken = this.getStoredToken(user);
        if (storedToken == null) {
            return UserUtil.PasswordResetTokenValidation.Status.EXPIRED;
        }
        if (storedToken.equals(token)) {
            return UserUtil.PasswordResetTokenValidation.Status.OK;
        }
        return UserUtil.PasswordResetTokenValidation.Status.UNEQUAL;
    }

    void resetToken(User user) {
        this.recordTokenImpl(user, null, null);
    }

    private String genSecureToken() {
        return DefaultSecureTokenGenerator.getInstance().generateToken();
    }

    private String getStoredToken(User user) {
        UserWithAttributes userWithAttributes = this.crowdService.getUserWithAttributes(user.getName());
        String expiryStr = userWithAttributes.getValue(PASSWORD_RESET_REQUEST_EXPIRY);
        if (expiryStr == null) {
            return null;
        }
        long expiry = Long.parseLong(expiryStr);
        if (this.now().getMillis() > expiry) {
            return null;
        }
        return userWithAttributes.getValue(PASSWORD_RESET_REQUEST_TOKEN);
    }

    private long genExpiryTime() {
        return this.now().plusHours(24).getMillis();
    }

    private DateTime now() {
        return new DateTime(this.clock.getCurrentDate().getTime(), DateTimeZone.UTC);
    }

    private void recordToken(User user, String token, long expiryTime) {
        this.recordTokenImpl(user, token, String.valueOf(expiryTime));
    }

    private void recordTokenImpl(User user, String token, String expiryTime) {
        try {
            if (token == null) {
                this.crowdService.removeUserAttribute(user, PASSWORD_RESET_REQUEST_EXPIRY);
                this.crowdService.removeUserAttribute(user, PASSWORD_RESET_REQUEST_TOKEN);
            } else {
                this.crowdService.setUserAttribute(user, PASSWORD_RESET_REQUEST_EXPIRY, expiryTime);
                this.crowdService.setUserAttribute(user, PASSWORD_RESET_REQUEST_TOKEN, token);
            }
        }
        catch (OperationNotPermittedException e) {
            log.error((Object)e);
        }
    }

    private void safelyRemove(PropertySet propertySet, String key) {
        if (StringUtils.isNotBlank((String)propertySet.getString(key))) {
            propertySet.remove(key);
        }
    }
}

