/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.profile;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.profile.AbstractUserProfileFragment;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.GroupPermissionChecker;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DetailsUserProfileFragment
extends AbstractUserProfileFragment {
    private final EmailFormatter emailFormatter;
    private final GroupPermissionChecker groupPermissionChecker;
    private final PermissionManager permissionManager;
    private final CrowdService crowdService;
    private final UserPropertyManager userPropertyManager;
    private final WebResourceManager webResourceManager;
    private final AvatarManager avatarManager;
    private final UserManager userManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public DetailsUserProfileFragment(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, VelocityManager velocityManager, EmailFormatter emailFormatter, GroupPermissionChecker groupPermissionChecker, PermissionManager permissionManager, CrowdService crowdService, UserPropertyManager userPropertyManager, WebResourceManager webResourceManager, AvatarManager avatarManager, UserManager userManager, VelocityRequestContextFactory velocityRequestContextFactory) {
        super(applicationProperties, jiraAuthenticationContext, velocityManager);
        this.emailFormatter = emailFormatter;
        this.groupPermissionChecker = groupPermissionChecker;
        this.permissionManager = permissionManager;
        this.crowdService = crowdService;
        this.userPropertyManager = userPropertyManager;
        this.webResourceManager = webResourceManager;
        this.avatarManager = avatarManager;
        this.userManager = userManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    @Override
    protected Map<String, Object> createVelocityParams(User profileUser, User currentUser) {
        List<String> groups;
        this.webResourceManager.requireResource("jira.webresources:avatar-picker");
        Map<String, Object> params = super.createVelocityParams(profileUser, currentUser);
        params.put("currentUserIsProfileUser", currentUser.equals(profileUser));
        params.put("user", profileUser);
        params.put("canEditAvatar", this.avatarManager.hasPermissionToEdit(currentUser, Avatar.Type.USER, profileUser.getName()));
        params.put("defaultAvatarId", this.avatarManager.getDefaultAvatarId(Avatar.Type.USER));
        PropertySet propertySet = this.userPropertyManager.getPropertySet(profileUser);
        if (propertySet.exists("user.avatar.id")) {
            params.put("avatarId", propertySet.getLong("user.avatar.id"));
        } else {
            params.put("avatarId", this.avatarManager.getDefaultAvatarId(Avatar.Type.USER));
        }
        params.put("avatarSrc", this.getBaseUrl() + "/secure/useravatar?size=large&ownerId=" + TextUtils.htmlEncode((String)profileUser.getName()) + "&avatarId=" + params.get("avatarId"));
        params.put("displayEdit", this.displayEdit(profileUser, currentUser));
        boolean isAdmin = this.isAdmin(currentUser);
        params.put("isAdmin", isAdmin);
        params.put("displayChangePassword", this.displayChangePassword(profileUser, currentUser));
        params.put("displayRememberMe", this.displayRememberMe(profileUser, currentUser));
        if (this.emailFormatter.emailVisible(currentUser)) {
            params.put("email", this.emailFormatter.formatEmailAsLink(profileUser.getEmailAddress(), currentUser));
        }
        if (!(groups = this.getGroups(profileUser, currentUser)).isEmpty()) {
            params.put("groups", groups);
        }
        params.put("userProperties", this.getUserProperties(profileUser, isAdmin));
        return params;
    }

    public String getBaseUrl() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    @Override
    public String getId() {
        return "details-profile-fragment";
    }

    private boolean displayEdit(User profileUser, User currentUser) {
        if (this.userManager.canUpdateUser(profileUser)) {
            return profileUser.equals(currentUser);
        }
        return false;
    }

    private boolean displayChangePassword(User profileUser, User currentUser) {
        if (this.userManager.canUpdateUserPassword(profileUser)) {
            return profileUser.equals(currentUser);
        }
        return false;
    }

    private Object displayRememberMe(User profileUser, User currentUser) {
        return profileUser.equals(currentUser);
    }

    private List<String> getGroups(User profileUser, User currentUser) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String group : this.getGroupsForUser(profileUser.getName())) {
            if (!this.groupPermissionChecker.hasViewGroupPermission(group, currentUser)) continue;
            groups.add(group);
        }
        return groups;
    }

    private boolean isAdmin(User currentUser) {
        return this.permissionManager.hasPermission(0, currentUser);
    }

    private Map<String, String> getUserProperties(User profileUser, boolean isAdmin) {
        HashMap<String, String> userProperties = new HashMap<String, String>();
        if (profileUser != null && isAdmin) {
            PropertySet userPropertySet = this.userPropertyManager.getPropertySet(profileUser);
            for (String key : userPropertySet.getKeys(5)) {
                if (!key.startsWith("jira.meta.")) continue;
                userProperties.put(key.substring("jira.meta.".length()), userPropertySet.getString(key));
            }
        }
        return userProperties;
    }

    private Iterable<String> getGroupsForUser(String userName) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1);
        Iterable groups = this.crowdService.search((Query)membershipQuery);
        return groups;
    }
}

