/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryStore;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.atlassian.util.concurrent.Supplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SessionBasedAnonymousUserHistoryStore
implements UserHistoryStore {
    private static final int DEFAULT_MAX_ITEMS = 20;
    private static final Logger log = Logger.getLogger(SessionBasedAnonymousUserHistoryStore.class);
    private final Function<VelocityRequestSession, ManagedLock> lockManager = ManagedLocks.weakManagedLockFactory((Function)new Function<VelocityRequestSession, String>(){

        public String get(VelocityRequestSession input) {
            return input.getId();
        }
    });
    private final UserHistoryStore delegatingStore;
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    static final String SESSION_PREFIX = "history-";

    public SessionBasedAnonymousUserHistoryStore(UserHistoryStore delegatingStore, ApplicationProperties applicationProperties, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.delegatingStore = delegatingStore;
        this.applicationProperties = applicationProperties;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    public VelocityRequestSession getSession() {
        VelocityRequestSession session = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getSession();
        if (session == null || session.getId() == null) {
            return null;
        }
        return session;
    }

    @Override
    public void addHistoryItem(final @NotNull User user, final @NotNull UserHistoryItem historyItem) {
        Assertions.notNull((String)"historyItem", (Object)historyItem);
        final VelocityRequestSession session = this.getSession();
        if (session == null) {
            if (user == null) {
                return;
            }
            this.delegatingStore.addHistoryItem(user, historyItem);
            return;
        }
        ((ManagedLock)this.lockManager.get((Object)session)).withLock(new Runnable(){

            @Override
            public void run() {
                String SESSION_KEY = SessionBasedAnonymousUserHistoryStore.SESSION_PREFIX + historyItem.getType().getName();
                List sessionHistory = (List)session.getAttribute(SESSION_KEY);
                if (sessionHistory != null && !sessionHistory.isEmpty() && user != null) {
                    SessionBasedAnonymousUserHistoryStore.this.copySessionToStore(user, sessionHistory);
                    session.removeAttribute(SESSION_KEY);
                    SessionBasedAnonymousUserHistoryStore.this.delegatingStore.addHistoryItem(user, historyItem);
                } else if (user != null) {
                    SessionBasedAnonymousUserHistoryStore.this.delegatingStore.addHistoryItem(user, historyItem);
                } else if (sessionHistory == null) {
                    ArrayList<UserHistoryItem> newHistory = new ArrayList<UserHistoryItem>();
                    newHistory.add(historyItem);
                    session.setAttribute(SESSION_KEY, newHistory);
                } else {
                    int index = SessionBasedAnonymousUserHistoryStore.this.getIndexOfHistoryItem(sessionHistory, historyItem);
                    if (index == -1) {
                        sessionHistory.add(0, historyItem);
                        int maxItems = SessionBasedAnonymousUserHistoryStore.this.getMaxItems(historyItem.getType());
                        if (sessionHistory.size() > maxItems) {
                            while (sessionHistory.size() > maxItems) {
                                sessionHistory.remove(sessionHistory.size() - 1);
                            }
                        }
                    } else {
                        sessionHistory.remove(index);
                        sessionHistory.add(0, historyItem);
                    }
                }
            }
        });
    }

    private void copySessionToStore(User user, List<UserHistoryItem> sessionItems) {
        for (int i = sessionItems.size(); i > 0; --i) {
            UserHistoryItem userHistoryItem = sessionItems.get(i - 1);
            this.delegatingStore.addHistoryItem(user, userHistoryItem);
        }
    }

    private int getIndexOfHistoryItem(List<UserHistoryItem> history, UserHistoryItem historyItem) {
        for (int i = 0; i < history.size(); ++i) {
            UserHistoryItem currentHistoryItem = history.get(i);
            if (!currentHistoryItem.getEntityId().equals(historyItem.getEntityId()) || !currentHistoryItem.getType().equals((Object)historyItem.getType())) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    public List<UserHistoryItem> getHistory(final UserHistoryItem.Type type, final User user) {
        Assertions.notNull((String)"type", (Object)type);
        final VelocityRequestSession session = this.getSession();
        if (session == null) {
            if (user == null) {
                return Collections.emptyList();
            }
            return this.delegatingStore.getHistory(type, user);
        }
        try {
            return (List)((ManagedLock)this.lockManager.get((Object)session)).withLock((Supplier)new Supplier<List<UserHistoryItem>>(){

                public List<UserHistoryItem> get() {
                    String SESSION_KEY = SessionBasedAnonymousUserHistoryStore.SESSION_PREFIX + type.getName();
                    List sessionHistory = (List)session.getAttribute(SESSION_KEY);
                    if (sessionHistory != null && !sessionHistory.isEmpty() && user != null) {
                        SessionBasedAnonymousUserHistoryStore.this.copySessionToStore(user, sessionHistory);
                        session.removeAttribute(SESSION_KEY);
                        return SessionBasedAnonymousUserHistoryStore.this.delegatingStore.getHistory(type, user);
                    }
                    if (user != null) {
                        return SessionBasedAnonymousUserHistoryStore.this.delegatingStore.getHistory(type, user);
                    }
                    if (sessionHistory == null) {
                        ArrayList<UserHistoryItem> newHistory = new ArrayList<UserHistoryItem>();
                        session.setAttribute(SESSION_KEY, newHistory);
                        return newHistory;
                    }
                    return sessionHistory;
                }
            });
        }
        catch (RuntimeException e) {
            log.error((Object)"Exception thrown while retrieving UserhistoryItems.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Set<UserHistoryItem.Type> removeHistoryForUser(@NotNull User user) {
        if (user == null) {
            return Collections.emptySet();
        }
        return this.delegatingStore.removeHistoryForUser(user);
    }

    private int getMaxItems(UserHistoryItem.Type type) {
        String maxItemsForTypeStr = this.applicationProperties.getDefaultBackedString("jira.max." + type.getName() + ".history.items");
        int maxItems = 20;
        try {
            if (StringUtils.isNotBlank((String)maxItemsForTypeStr)) {
                return Integer.parseInt(maxItemsForTypeStr);
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Incorrect format of property 'jira.max.history.items'.  Should be a number.");
        }
        String maxItemsStr = this.applicationProperties.getDefaultBackedString("jira.max.history.items");
        try {
            if (StringUtils.isNotBlank((String)maxItemsStr)) {
                return Integer.parseInt(maxItemsStr);
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Incorrect format of property 'jira.max.history.items'.  Should be a number.");
        }
        return 20;
    }
}

