/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build633
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build633.class);
    public static final String CF_VALUE_ENTITY = "CustomFieldValue";
    public static final String CF_VALUE_OPTION = "CustomFieldOption";
    private final CustomFieldManager customFieldManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final IssueManager issueManager;
    private final OfBizDelegator ofBizDelegator;
    private final GenericConfigManager genericConfigManager;
    private static List<String> atlassianList = new ArrayList<String>();
    private static List<String> blacklist;

    public UpgradeTask_Build633(CustomFieldManager customFieldManager, FieldConfigSchemeManager fieldConfigSchemeManager, OfBizDelegator ofBizDelegator, IssueManager issueManager, GenericConfigManager genericConfigManager) {
        super(false);
        this.customFieldManager = customFieldManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.ofBizDelegator = ofBizDelegator;
        this.issueManager = issueManager;
        this.genericConfigManager = genericConfigManager;
    }

    @Override
    public String getBuildNumber() {
        return "633";
    }

    @Override
    public String getShortDescription() {
        return "Converting Custom field values for Select and MultiSelect types to store the id of the option rather than the value.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List<CustomField> customFieldList = this.getCustomFields();
        int i = 0;
        for (CustomField customField : customFieldList) {
            log.info((Object)("Updating custom field '" + customField.getName() + "', " + ++i + " of " + customFieldList.size()));
            this.processCustomFieldOptions(customField);
            this.processCustomFieldDefaults(customField);
        }
    }

    private void processCustomFieldDefaults(CustomField customField) {
        HashSet<Long> configIds = new HashSet<Long>();
        List fieldConfigSchemes = this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)customField);
        for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
            Map configs = fieldConfigScheme.getConfigs();
            for (FieldConfig fieldConfig : configs.values()) {
                configIds.add(fieldConfig.getId());
            }
        }
        for (Long configId : configIds) {
            Object defaultObject = this.genericConfigManager.retrieve("DefaultValue", configId.toString());
            if (defaultObject == null) continue;
            HashSet<Long> defaultIds = new HashSet<Long>();
            if (defaultObject instanceof Collection) {
                Collection defaults = (Collection)defaultObject;
                for (Object aDefault : defaults) {
                    List optionGvs;
                    if (!(aDefault instanceof String) || (optionGvs = this.ofBizDelegator.findByAnd(CF_VALUE_OPTION, MapBuilder.build((Object)"customfield", (Object)customField.getIdAsLong(), (Object)"customfieldconfig", (Object)configId, (Object)"value", aDefault))).size() <= 0) continue;
                    defaultIds.add(((GenericValue)optionGvs.get(0)).getLong("id"));
                }
                this.genericConfigManager.update("DefaultValue", configId.toString(), defaultIds);
                continue;
            }
            if (defaultObject instanceof String) {
                String aDefault = (String)defaultObject;
                if (aDefault == null) continue;
                List optionGvs = this.ofBizDelegator.findByAnd(CF_VALUE_OPTION, MapBuilder.build((Object)"customfield", (Object)customField.getIdAsLong(), (Object)"customfieldconfig", (Object)configId, (Object)"value", (Object)aDefault));
                if (optionGvs.size() > 0) {
                    this.genericConfigManager.update("DefaultValue", configId.toString(), (Object)((GenericValue)optionGvs.get(0)).getLong("id"));
                    continue;
                }
                this.genericConfigManager.remove("DefaultValue", configId.toString());
                continue;
            }
            this.genericConfigManager.remove("DefaultValue", configId.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCustomFieldOptions(CustomField customField) throws GenericEntityException {
        int logCount = 0;
        OfBizListIterator iterator = null;
        try {
            iterator = this.ofBizDelegator.findListIteratorByCondition(CF_VALUE_ENTITY, (EntityCondition)new EntityExpr("customfield", EntityOperator.EQUALS, (Object)customField.getGenericValue().getLong("id")), null, null, null, null);
            GenericValue gv = iterator.next();
            while (gv != null) {
                if (gv.get("numbervalue") == null) {
                    Long issueId = gv.getLong("issue");
                    Long customFieldId = gv.getLong("customfield");
                    FieldConfig fieldConfig = null;
                    MutableIssue issue = this.issueManager.getIssueObject(issueId);
                    if (issue != null) {
                        fieldConfig = this.fieldConfigSchemeManager.getRelevantConfig((IssueContext)issue, (ConfigurableField)customField);
                    } else {
                        Map allConfigs;
                        List allConfigSchemes = this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)customField);
                        if (allConfigSchemes != null && allConfigSchemes.size() > 0 && (allConfigs = ((FieldConfigScheme)allConfigSchemes.get(0)).getConfigs()) != null && allConfigs.size() > 0) {
                            fieldConfig = (FieldConfig)allConfigs.values().iterator().next();
                        }
                    }
                    if (fieldConfig != null) {
                        List optionGvs = this.ofBizDelegator.findByAnd(CF_VALUE_OPTION, MapBuilder.build((Object)"customfield", (Object)customFieldId, (Object)"customfieldconfig", (Object)fieldConfig.getId(), (Object)"value", (Object)gv.getString("stringvalue")));
                        if (optionGvs.size() == 0) {
                            if (atlassianList.contains(customField.getCustomFieldType().getClass().getName())) {
                                gv.setString("stringvalue", null);
                                gv.set("numbervalue", (Object)-1L);
                                this.maybeLog("cleared", customField.getName(), gv.getString("stringvalue"), logCount);
                                ++logCount;
                            } else {
                                gv.set("numbervalue", (Object)-1L);
                                this.maybeLog("not converted", customField.getName(), gv.getString("stringvalue"), logCount);
                                ++logCount;
                            }
                        } else {
                            Long optionId = ((GenericValue)optionGvs.get(0)).getLong("id");
                            gv.setString("stringvalue", optionId.toString());
                            gv.set("numbervalue", (Object)optionId);
                        }
                        gv.store();
                    }
                }
                gv = iterator.next();
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    private void maybeLog(String s, String name, String stringvalue, int logCount) {
        if (logCount <= 10) {
            log.info((Object)("No option found for Custom field '" + name + "' Field value '" + stringvalue + "'. Value " + s + "."));
        } else if (logCount == 11) {
            log.info((Object)("No option found for Custom field '" + name + "' Field value ' more than 10 times."));
        }
    }

    private List<CustomField> getCustomFields() {
        ArrayList<CustomField> selectCustomFields = new ArrayList<CustomField>();
        List customFields = this.customFieldManager.getCustomFieldObjects();
        for (CustomField customField : customFields) {
            CustomFieldType type = customField.getCustomFieldType();
            if (!(type instanceof SelectCFType) && !(type instanceof MultiSelectCFType) || blacklist.contains(type.getClass().getName())) continue;
            selectCustomFields.add(customField);
        }
        return selectCustomFields;
    }

    static {
        atlassianList.add("com.atlassian.jira.issue.customfields.impl.SelectCFType");
        atlassianList.add("com.atlassian.jira.issue.customfields.impl.MultiSelectCFType");
        blacklist = new ArrayList<String>();
        blacklist.add("is.origo.jira.plugin.customFields.BillingKeyCustomField");
    }
}

