/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build176
extends AbstractUpgradeTask {
    public static final String PROJECT_ROLE_SECURITY_TYPE = "projectrole";
    private ProjectManager projectManager;
    private PermissionSchemeManager schemeManager;
    private ProjectRoleManager projectRoleManager;
    protected Map groupToRoleMappings;

    public UpgradeTask_Build176(ProjectManager projectManager, PermissionSchemeManager schemeManager, ProjectRoleManager projectRoleManager) {
        super(false);
        this.projectManager = projectManager;
        this.schemeManager = schemeManager;
        this.projectRoleManager = projectRoleManager;
        this.groupToRoleMappings = new HashMap();
    }

    @Override
    public String getShortDescription() {
        return "Upgrade the default permission scheme to contain references to roles instead of groups, only if there are no projects currently within JIRA (i.e. we have just setup a new instance of JIRA)";
    }

    @Override
    public String getBuildNumber() {
        return "176";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (this.projectManager.getProjects().size() == 0) {
            this.initGroupToProjectRoleMappings();
            this.convertDefaultPermissionSchemeToUseRoles();
        }
    }

    protected void initGroupToProjectRoleMappings() {
        for (ProjectRole projectRole : this.projectRoleManager.getProjectRoles()) {
            if ("Administrators".equals(projectRole.getName())) {
                this.groupToRoleMappings.put("jira-administrators", projectRole.getId());
                continue;
            }
            if ("Developers".equals(projectRole.getName())) {
                this.groupToRoleMappings.put("jira-developers", projectRole.getId());
                continue;
            }
            if (!"Users".equals(projectRole.getName())) continue;
            this.groupToRoleMappings.put("jira-users", projectRole.getId());
        }
    }

    protected void convertDefaultPermissionSchemeToUseRoles() throws GenericEntityException {
        GenericValue scheme = this.schemeManager.getDefaultScheme();
        List schemeEntities = this.schemeManager.getEntities(scheme);
        for (GenericValue schemeEntity : schemeEntities) {
            Long newParameter;
            if (!"group".equals(schemeEntity.getString("type")) || (newParameter = (Long)this.groupToRoleMappings.get(schemeEntity.getString("parameter"))) == null) continue;
            schemeEntity.setString("type", PROJECT_ROLE_SECURITY_TYPE);
            schemeEntity.setString("parameter", newParameter.toString());
            schemeEntity.store();
        }
    }
}

