/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.trackback;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.TextAnalyzer;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.JiraEntityUtils;
import com.atlassian.trackback.Trackback;
import com.atlassian.trackback.TrackbackHelper;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class TrackbackTextAnalyzer
implements TextAnalyzer {
    private static final Logger log = Logger.getLogger(TrackbackTextAnalyzer.class);
    private final TrackbackHelper helper;
    private final ApplicationProperties props;
    private final PermissionManager permissionManager;

    public TrackbackTextAnalyzer(TrackbackHelper helper, ApplicationProperties props, PermissionManager permissionManager) {
        this.helper = helper;
        this.props = props;
        this.permissionManager = permissionManager;
    }

    @Override
    public void analyseContent(GenericValue issue, String content, GenericValue action) {
        boolean publicContent = true;
        if (action != null && "comment".equals(action.get("type")) && action.get("level") != null) {
            publicContent = false;
        }
        if (!(!this.props.getOption("jira.option.trackback.send.public") || this.permissionManager.hasPermission(10, issue, null) && publicContent)) {
            return;
        }
        String htmlizedContent = TextUtils.plainTextToHtml((String)content);
        String key = issue.getString("key");
        Trackback ping = new Trackback();
        ping.setBlogName("JIRA: " + JiraEntityUtils.getProject(issue).getString("name"));
        ping.setTitle("[" + key + "] " + issue.getString("summary"));
        ping.setUrl(this.props.getString("jira.baseurl") + "/browse/" + key);
        ping.setExcerpt(content);
        try {
            this.helper.pingTrackbacksInContent(htmlizedContent, ping);
        }
        catch (IOException e) {
            log.error((Object)("Error pinging trackbacks for content in issue " + key + ": "), (Throwable)e);
        }
    }

    @Override
    public void analyseContent(GenericValue issue, String content) {
        this.analyseContent(issue, content, null);
    }

    @Override
    public void analyseContent(Issue issue, String content, GenericValue action) {
        this.analyseContent(issue.getGenericValue(), content, action);
    }

    @Override
    public void analyseContent(Issue issue, String content) {
        this.analyseContent(issue, content, null);
    }
}

