/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.trackback;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.trackback.JiraTrackbackFinder;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class PingUrlFilterer {
    private static final Logger log = Logger.getLogger(JiraTrackbackFinder.class);
    final ApplicationProperties appProps;

    public PingUrlFilterer(ApplicationProperties appProps) {
        this.appProps = appProps;
    }

    public List filterPingUrls(List urls) {
        ArrayList<String> validPingUrls = new ArrayList<String>();
        for (String url : urls) {
            if (!this.isValidPingUrl(url)) continue;
            validPingUrls.add(url);
        }
        return validPingUrls;
    }

    private boolean isValidPingUrl(String url) {
        Perl5Matcher patternMatcher = new Perl5Matcher();
        for (Pattern pattern : this.getPatternsToLimitBy()) {
            if (!patternMatcher.matches(url, pattern)) continue;
            log.info((Object)("The URL: " + url + " has been excluded as it matches the following regular expression pattern : " + pattern.getPattern()));
            return false;
        }
        return true;
    }

    private Collection getPatternsToLimitBy() {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        Perl5Compiler patternCompiler = new Perl5Compiler();
        for (String expression : this.getStringExpressions()) {
            if (expression == null) continue;
            try {
                Pattern pattern = patternCompiler.compile(expression, 1);
                patterns.add(pattern);
            }
            catch (MalformedPatternException e) {
                log.error((Object)("Error compiling regular expression for : " + expression + "."), (Throwable)e);
            }
        }
        return patterns;
    }

    private Collection getStringExpressions() {
        String strings = this.appProps.getDefaultBackedString("jira.trackback.exclude.pattern");
        String baseUrl = this.appProps.getDefaultBackedString("jira.baseurl");
        ArrayList<String> stringList = new ArrayList<String>();
        if (TextUtils.stringSet((String)strings)) {
            StringTokenizer tokenizer = new StringTokenizer(strings, "\n\f\r");
            while (tokenizer.hasMoreTokens()) {
                stringList.add(tokenizer.nextToken());
            }
        }
        if (TextUtils.stringSet((String)baseUrl)) {
            stringList.add(baseUrl + ".*");
        }
        return stringList;
    }
}

