/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.timezone;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.timezone.RegionInfo;
import com.atlassian.jira.timezone.RegionInfoImpl;
import com.atlassian.jira.timezone.TimeZoneIds;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneInfoImpl;
import com.atlassian.jira.timezone.TimeZoneResolver;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class TimeZoneServiceImpl
implements TimeZoneService,
TimeZoneResolver {
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final UserPreferencesManager userPreferencesManager;
    private static final String[] ALLOWED_REGIONS = new String[]{"Etc", "Pacific", "America", "Antarctica", "Atlantic", "Africa", "Europe", "Asia", "Indian", "Australia"};
    private static final String[] FILTERED_IDS = new String[]{"Etc/UCT", "Etc/UTC"};

    public TimeZoneServiceImpl(ApplicationProperties applicationProperties, PermissionManager permissionManager, UserPreferencesManager userPreferencesManager) {
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.userPreferencesManager = userPreferencesManager;
    }

    public TimeZoneInfo getDefaultTimeZoneInfo(JiraServiceContext serviceContext) {
        String defaultTimeZoneStr = this.getDefaultTimeZoneId();
        if (StringUtils.isEmpty((String)defaultTimeZoneStr)) {
            TimeZone jvmTimeZone = this.getJVMTimeZoneInfo(serviceContext).toTimeZone();
            return this.getTimeZoneInfo(jvmTimeZone, serviceContext);
        }
        return this.getTimeZoneInfo(TimeZone.getTimeZone(defaultTimeZoneStr), serviceContext);
    }

    private String getDefaultTimeZoneId() {
        return this.applicationProperties.getString("jira.default.timezone");
    }

    public boolean useSystemTimeZone() {
        return StringUtils.isEmpty((String)this.getDefaultTimeZoneId());
    }

    public List<RegionInfo> getTimeZoneRegions(JiraServiceContext serviceContext) {
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(ALLOWED_REGIONS.length);
        for (String regionId : ALLOWED_REGIONS) {
            regions.add(new RegionInfoImpl(regionId, serviceContext.getI18nBean().getText("timezone.region." + regionId.toLowerCase())));
        }
        Collections.sort(regions);
        return regions;
    }

    private String getRegionFromTimeZoneId(String timeZoneId) {
        int firstSlashIndex = timeZoneId.indexOf("/");
        if (firstSlashIndex != -1) {
            String region = timeZoneId.substring(0, firstSlashIndex);
            return region;
        }
        return timeZoneId;
    }

    public List<TimeZoneInfo> getTimeZoneInfos(JiraServiceContext serviceContext) {
        Iterable<String> timeZoneIds = this.getAllowedCannonicalIds();
        ArrayList<TimeZoneInfo> timeZoneInfos = new ArrayList<TimeZoneInfo>();
        for (String timeZoneId : timeZoneIds) {
            String region = this.getRegionFromTimeZoneId(timeZoneId);
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
            TimeZoneInfoImpl timeZoneInfo = new TimeZoneInfoImpl(timeZoneId, timeZone.getDisplayName(serviceContext.getI18nBean().getLocale()), timeZone, serviceContext.getI18nBean(), region);
            timeZoneInfos.add(timeZoneInfo);
        }
        Collections.sort(timeZoneInfos);
        return timeZoneInfos;
    }

    private Iterable<String> getAllowedCannonicalIds() {
        return Iterables.filter(TimeZoneIds.getCanonicalIds(), (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String timeZoneId) {
                for (String filteredId : FILTERED_IDS) {
                    if (!filteredId.equals(timeZoneId)) continue;
                    return false;
                }
                for (String allowedRegion : ALLOWED_REGIONS) {
                    if (timeZoneId == null || !timeZoneId.startsWith(allowedRegion)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private TimeZoneInfo getTimeZoneInfo(TimeZone timeZone, JiraServiceContext serviceContext) {
        return new TimeZoneInfoImpl(timeZone.getID(), timeZone.getDisplayName(serviceContext.getI18nBean().getLocale()), timeZone, serviceContext.getI18nBean(), this.getRegionFromTimeZoneId(timeZone.getID()));
    }

    public TimeZoneInfo getJVMTimeZoneInfo(JiraServiceContext serviceContext) {
        TimeZone canonicalJVMTimeZone = TimeZoneIds.ensureCanonicalTimeZone(this.getJVMTimeZone());
        return this.getTimeZoneInfo(canonicalJVMTimeZone, serviceContext);
    }

    protected TimeZone getJVMTimeZone() {
        return TimeZone.getDefault();
    }

    public void setDefaultTimeZone(String timeZoneId, JiraServiceContext serviceContext) {
        TimeZone timeZone = this.validateTimeZoneId(timeZoneId);
        this.checkAdministratorPermission(serviceContext);
        this.applicationProperties.setString("jira.default.timezone", timeZone.getID());
    }

    private TimeZone validateTimeZoneId(String timeZoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        HashSet allowedIds = new HashSet();
        Iterables.addAll(allowedIds, this.getAllowedCannonicalIds());
        if (!allowedIds.contains(timeZoneId)) {
            throw new IllegalArgumentException("Timezone with id '" + timeZoneId + "' not supported. Only these IDs are supported: '" + ((Object)allowedIds).toString() + "'");
        }
        if (!timeZone.getID().equals(timeZoneId)) {
            throw new IllegalArgumentException("No timezone found with id '" + timeZoneId + "'");
        }
        return timeZone;
    }

    public void clearDefaultTimeZone(JiraServiceContext serviceContext) {
        this.checkAdministratorPermission(serviceContext);
        this.applicationProperties.setString("jira.default.timezone", null);
    }

    private void checkAdministratorPermission(JiraServiceContext serviceContext) {
        if (!this.permissionManager.hasPermission(0, serviceContext.getLoggedInUser())) {
            throw new RuntimeException("This user does not have the JIRA Administrator permission. This permission is required to change the default timezone.");
        }
    }

    public String getDefaultTimeZoneRegionKey() {
        if (this.useSystemTimeZone()) {
            return "System";
        }
        return this.getRegionFromTimeZoneId(this.getDefaultTimeZoneId());
    }

    public void clearUserDefaultTimeZone(JiraServiceContext serviceContext) {
        Preferences preferences = this.userPreferencesManager.getPreferences(serviceContext.getLoggedInUser());
        try {
            preferences.setString("jira.user.timezone", null);
        }
        catch (AtlassianCoreException e) {
            throw new RuntimeException("Failed to set timezone for user '" + serviceContext.getLoggedInUser().getName() + "' to JIRA's default timezone", e);
        }
    }

    public TimeZoneInfo getUserTimeZoneInfo(JiraServiceContext serviceContext) {
        String timezoneId;
        Preferences preferences = this.userPreferencesManager.getPreferences(serviceContext.getLoggedInUser());
        String string = timezoneId = preferences != null ? preferences.getString("jira.user.timezone") : null;
        if (StringUtils.isEmpty((String)timezoneId)) {
            return this.getDefaultTimeZoneInfo(serviceContext);
        }
        TimeZone timeZone = TimeZone.getTimeZone(timezoneId);
        return this.getTimeZoneInfo(timeZone, serviceContext);
    }

    public boolean usesJiraTimeZone(JiraServiceContext serviceContext) {
        Preferences preferences = this.userPreferencesManager.getPreferences(serviceContext.getLoggedInUser());
        return StringUtils.isEmpty((String)preferences.getString("jira.user.timezone"));
    }

    public void setUserDefaultTimeZone(String timeZoneId, JiraServiceContext serviceContext) {
        Preferences preferences = this.userPreferencesManager.getPreferences(serviceContext.getLoggedInUser());
        this.validateTimeZoneId(timeZoneId);
        try {
            preferences.setString("jira.user.timezone", timeZoneId);
        }
        catch (AtlassianCoreException e) {
            throw new RuntimeException("Failed to set the timezone with id '" + timeZoneId + "' for user '" + serviceContext.getLoggedInUser() + "'", e);
        }
    }

    @Override
    public TimeZone getDefaultTimeZone(JiraServiceContext serviceContext) {
        return this.getDefaultTimeZoneInfo(serviceContext).toTimeZone();
    }

    @Override
    public TimeZone getUserTimeZone(JiraServiceContext serviceContext) {
        return this.getUserTimeZoneInfo(serviceContext).toTimeZone();
    }
}

